#!/bin/bash

# Build Docker files for a CLEV2ER SII Release
# Run this from clopr@msslxbd (had docker installed)
# Go to ~/software/clev2er_sii

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

FILE=./src/clev2er/tools/run_chain.py

# Extract the current version number from FILE
CURRENT_VERSION=$(grep -Eo 'this_version = "[0-9]+\.[0-9]+\.[0-9]+"' "$FILE" | grep -Eo '[0-9]+\.[0-9]+\.[0-9]+')

echo "CURRENT_VERSION= $CURRENT_VERSION"

# Builds we require without testdata_external
#   1) - with both SI + IB
#   2) - with just SI
#   3) - with just IB

for type in siib si ib
do
    echo -e "${BLUE}Building Docker image for version $CURRENT_VERSION for $type ...${NC}"

    # Select the Dockerfile to use for this build
    cp Dockerfile.ubuntu_latest Dockerfile

    sed -i "s/theme/${type}:${CURRENT_VERSION}/" Dockerfile

    cp .dockerignore_$type .dockerignore
    docker build -t clev2er/${type}:$CURRENT_VERSION .
    docker tag clev2er/${type}:$CURRENT_VERSION clev2er/${type}:latest

    gzfile=clev2er_sii_${type}-$CURRENT_VERSION.docker.tar.gz
    [ -f $gzfile ] && rm -f $gzfile

    echo "Saving docker image..."
    docker save -o ${gzfile%.gz} clev2er/${type}:$CURRENT_VERSION   
    echo "Compressing docker image..."
    gzip -f ${gzfile%.gz}   
    echo "Docker image size:"
    ls -lh $gzfile
    chmod 666 $gzfile
    echo "checksum hash code for $gzfile"
    sha256sum $gzfile > ${gzfile}.sha256

    echo "Loading the docker image..."
    docker load -i $gzfile
    echo "Run the docker image to get OS version..."
    docker run --rm clev2er/${type}:$CURRENT_VERSION cat /etc/os-release 
    echo "Run the docker image to test run_chain version..."
    docker run --rm clev2er/${type}:$CURRENT_VERSION run_chain -v 
done

# Builds we require WITH testdata_external
#   1) - with both SI + IB
#   2) - with just SI
#   3) - with just IB

# Select the Dockerfile to use for this build
cp Dockerfile.ubuntu_latest Dockerfile

for type in siib si ib
do
    echo -e "${BLUE}Building Docker image for version $CURRENT_VERSION for $type WITH TDS...${NC}"

    # Select the Dockerfile to use for this build
    cp Dockerfile.ubuntu_latest Dockerfile

    sed -i "s/theme/${type}:${CURRENT_VERSION}/" Dockerfile

    cp .dockerignore_${type}_with_tds .dockerignore
    docker build -t clev2er/${type}:$CURRENT_VERSION .
    docker tag clev2er/${type}:$CURRENT_VERSION clev2er/${type}:latest

    gzfile=clev2er_sii_${type}_with_tds-$CURRENT_VERSION.docker.tar.gz
    [ -f $gzfile ] && rm -f $gzfile

    echo "Saving docker image..."
    docker save -o ${gzfile%.gz} clev2er/${type}:$CURRENT_VERSION   
    echo "Compressing docker image..."
    gzip -f ${gzfile%.gz}   
    echo "Docker image size:"
    ls -lh $gzfile
    chmod 666 $gzfile
    echo "checksum hash code for $gzfile"
    sha256sum $gzfile > ${gzfile}.sha256

    echo "Loading the docker image..."
    docker load -i $gzfile
    echo "Run the docker image to get OS version..."
    docker run --rm clev2er/${type}:$CURRENT_VERSION cat /etc/os-release 
    echo "Run the docker image to test run_chain version..."
    docker run --rm clev2er/${type}:$CURRENT_VERSION run_chain -v 
done


echo -e "${BLUE}Transfering to release portal..${NC}"
rsync -av ./clev2er_sii_*-$CURRENT_VERSION.docker.tar.* asm@li1.cpom.ucl.ac.uk:/cpnet/www/cpom/downloads/clev2er_sii



