window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "clev2er", "modulename": "clev2er", "kind": "module", "doc": "<h1 id=\"clev2er-sea-ice-and-icebergs-gpp-project\">CLEV2ER Sea Ice and Icebergs GPP Project</h1>\n\n<p>Documentation for the CLEV2ER Sea Ice and Icebergs GPP project, hosted on GitHub at\n<a href=\"https://github.com/mssl-softeng/clev2er_sii\">github.com/mssl-softeng/clev2er_sii</a>.</p>\n\n<p>The GPP runs within a framework designed for (but not\nrestricted to) Level-1b to Level-2 processing of ESA radar altimetry mission data. The key features\nof the framework are dynamically loaded algorithm classes (from XML or YML lists of algorithms) and\nin-built support for multi-processing and a consistent automated development and testing workflow.\nThere are many run-time options in the chain controller command line tool.</p>\n\n<p>The diagram below shows a simplified representation of the framework and its components.</p>\n\n<p><img src=\"https://www.homepages.ucl.ac.uk/~ucasamu/cl_liiw_framework.png\" alt=\"CL-SII Framework\" /></p>\n\n<h2 id=\"main-features\">Main Features</h2>\n\n<ul>\n<li>Command line chain controller tool : src/clev2er/tools/run_chain.py</li>\n<li>input L1b file selection\n<ul>\n<li>single file</li>\n<li>multiple files from a single directory</li>\n<li>recursive search from a single directory</li>\n<li>date or time based search</li>\n<li>selection of CRISTAL instrument mode (SIC,SAC,SIO) and/or processing mode (HR,FF,LR,..)</li>\n</ul></li>\n<li>dynamic algorithm loading from XML or YML list(s)\n<ul>\n<li>algorithms are classes of type Algorithm with configurable .init(), .process(), .finalize()\nfunctions.</li>\n<li>Algorithm.init() is called before any L1b file processing.</li>\n<li>Algorithm.process() is called on every L1b file,</li>\n<li>Algorithm.finalize() is called after all files have been processed.</li>\n<li>Each algorithm has access to: L1b Dataset, shared working dict, config dict.</li>\n<li>Algorithm/chain configuration by XML or YAML configuration files.</li>\n<li>A shared python dictionary is used to pass algorithm outputs between algorithms in the chain.</li>\n</ul></li>\n<li>logging with standard warning, info, debug, error levels (+ multi-processing logging support)</li>\n<li>optional multi-processing built in, configurable maximum number of processes used.</li>\n<li>algorithm timing (with MP support)</li>\n<li>chain timing</li>\n<li>support for breakpoint files (saved as NetCDF4 files)</li>\n</ul>\n\n<h2 id=\"change-log\">Change Log</h2>\n\n<p>This section details major changes to the framework (not individual chains):</p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Change</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>01-Mar-25</td>\n  <td>Initial CLEV2ER SII repository setup, adapted from CLEV2ER LIIW</td>\n</tr>\n</tbody>\n</table>\n\n<h2 id=\"installation-of-the-framework-for-development\">Installation of the Framework for Development</h2>\n\n<p>This section describes installation of the framework for development purposes.\nSeperate procedures are documented in the CLEV2ER Software Installation &amp; User Manual (D-SUM)\nfor customer installation.</p>\n\n<p>Note that the framework installation has been tested on Linux and MacOS systems. Use on\nother operating systems is possible but may require additional install steps, and is not\ndirectly supported.</p>\n\n<p>Make sure you have <em>git</em> installed on your target system.</p>\n\n<p>Clone the git public repository in to a suitable directory on your system.\nThis will create a directory called <strong>/clev2er_sii</strong> in your current directory.</p>\n\n<p>with https:\n<code>git clone https://github.com/mssl-softeng/clev2er_sii.git</code></p>\n\n<p>or with ssh:\n<code>git clone git@github.com:mssl-softeng/clev2er_sii.git</code></p>\n\n<p>or with the GitHub CLI:\n<code>gh repo clone mssl-softeng/clev2er_sii</code></p>\n\n<p>Go to the CLEV2ER package base directory</p>\n\n<pre><code>cd clev2er_sii\n</code></pre>\n\n<h3 id=\"package-and-environment-installation\">Package and Environment Installation</h3>\n\n<p>To install the CLEV2ER package, run the following command (on a Linux\nor MacOS operating system):</p>\n\n<pre><code>./install_env.sh\n</code></pre>\n\n<p>This will</p>\n\n<ul>\n<li>install python 3.12 in a virtual env</li>\n<li>install poetry package manager</li>\n<li>install required python packages</li>\n<li>install pre-commit hooks</li>\n<li>create a setup script called <code>./activate.sh</code> to activate the environment\nand setup necessary environment variables</li>\n</ul>\n\n<h3 id=\"load-the-virtual-environment\">Load the Virtual Environment</h3>\n\n<p>Now you are all setup to go. Whenever you want to run any CLEV2ER chains you\nmust first load the CLEV2ER virtual environment using  the following steps:</p>\n\n<ul>\n<li>Go to the CLEV2ER package base directory (clev2er_sii)</li>\n<li>run :</li>\n</ul>\n\n<pre><code>source ./activate.sh\n</code></pre>\n\n<p>You should now be setup to run processing chains, etc.</p>\n\n<h2 id=\"run-a-simple-chain-test-example\">Run a simple chain test example</h2>\n\n<p>The following command will run a simple example test chain which dynamically loads\n2 template algorithms and runs them on a set of CryoSat L1b files in a test data directory.\nThe algorithms do not perform any actual processing as they are just template examples.\nMake sure you have the virtual environment already loaded using <code>poetry shell</code> before\nrunning this command.</p>\n\n<pre><code>run_chain.py -n testchain -d $CLEV2ER_BASE_DIR/testdata -r\n</code></pre>\n\n<p>There should be no errors. Note that run_chain.py is setup as an executable, so it is not\nnecessary to use <code>python run_chain.py</code>, although this will also work.</p>\n\n<p>Note that the algorithms that are dynamically run are located in\n$CLEV2ER_BASE_DIR/src/clev2er/algorithms/testchain/alg_template1.py, alg_template2.py</p>\n\n<p>The list of algorithms (and their order) for <em>testchain</em> are defined in\n$CLEV2ER_BASE_DIR/config/algorithm_lists/testchain/testchain_alglist.xml</p>\n\n<p>Chain configuration settings are defined in</p>\n\n<p>$CLEV2ER_BASE_DIR/config/main_config.xml and</p>\n\n<p>Algorithm configuration settings are defined in</p>\n\n<p>$CLEV2ER_BASE_DIR/config/chain_configs/testchain/testchain_config.xml</p>\n\n<p>To find all the command line options for <em>run_chain.py</em>, type:</p>\n\n<p><code>run_chain.py -h</code></p>\n\n<p>For further info, please see <code>clev2er.tools</code></p>\n\n<h2 id=\"developer-requirements\">Developer Requirements</h2>\n\n<p>This section details additional installation requirements for developers who will develop/adapt\nnew chains or algorithms.</p>\n\n<h2 id=\"developer-workflow\">Developer Workflow</h2>\n\n<p>This section describes the method that should be used to contribute to the project code.\nThe basic method to develop a new feature is:</p>\n\n<p>On your local repository:</p>\n\n<ol>\n<li><p>Make sure your local 'master' branch is checked out and up-to-date\n(some steps may not be necessary).</p>\n\n<p><pre><code>cd $CLEV2ER_BASE_DIR\ngit checkout master\ngit pull\n</code></pre></p></li>\n<li><p>Create a new branch, named xxx_featurename, where xxx is your initials</p>\n\n<p><code>git checkout -b xxx_featurename</code></p></li>\n<li><p>Develop and test your new feature within this branch, making git additions and commits\nas necessary.\nYou should have at least one commit (probably several).</p>\n\n<p><code>git commit -a -m \"description of change\"</code></p></li>\n<li><p>If you are developing a new module, then you must also write a pytest test\nfor that module in a tests directory located in the same directory as the module.\nNote the section on pytest markers at the end of this document.</p></li>\n<li><p>Static analysis tests will be run on your changes using pre-commit, either\nautomatically during a git commit or by running in the directory of the code\nchange or in the repository base directory (for a more complete check):</p>\n\n<p><code>pre-commit run --all</code></p></li>\n<li><p>Once tested, push the new feature branch to GitHub</p>\n\n<p><code>git push -u origin xxx_featurename</code>  [first time], or just <code>git push</code></p></li>\n<li><p>Go to GitHub: [github.com/mssl-softeng/clev2er_sii]\n(<a href=\"https://github.com/mssl-softeng/clev2er_sii\">https://github.com/mssl-softeng/clev2er_sii</a>)\nor direct to the pull request URL shown in your git pull command.</p></li>\n<li><p>Create a Pull Request on GitHub for your feature branch. This will automatically start a CI\nworkflow that tests your branch for code issues and runs pytest tests. If it fails you\nshould correct the errors on your local branch and repeat (steps 3 onwards) until it passes\nall tests.</p></li>\n<li><p>Finally your pull request will be reviewed and if accepted merged into the 'master' branch.</p></li>\n<li><p>You can then delete your local branch and the remote branch on Github.</p>\n\n<pre><code>git branch -d xxx_featurename\ngit push origin --delete xxx_featurename\n\n</code></pre></li>\n<li><p>Repeat the whole process to add your next feature.</p></li>\n</ol>\n\n<h2 id=\"framework-and-chain-configuration\">Framework and Chain Configuration</h2>\n\n<p>The framework (run controller) and individual named algorithm chains each have\nseparate configuration files. Configuration options can be categorized as:</p>\n\n<ul>\n<li>run controller (or main framework ) default configuration</li>\n<li>per chain default configuration (to configure individual algorithms and resources)</li>\n<li>command line options (for input selection and modifying any default configuration\noptions)</li>\n</ul>\n\n<p>Chains can be configured using XML or YAML configuration files and optional command line\noptions in the following order of increasing precedence:</p>\n\n<ul>\n<li>main config file: $CLEV2ER_BASE_DIR/config/main_config.xml [Must be XML]</li>\n<li>chain specific config file:\n$CLEV2ER_BASE_DIR/config/chain_configs/*chain_name<em>/</em>config_file_name*.xml,\nXML or .yml</li>\n<li>command line options</li>\n<li>command line additional config options using the --conf_opts</li>\n</ul>\n\n<p>The configurations are passed to\nthe chain's algorithms and finder classes, via a merged python dictionary, available\nto the Algorithm classes as self.config.</p>\n\n<h3 id=\"run-control-configuration\">Run Control Configuration</h3>\n\n<p>The default run control configuration file is <code>$CLEV2ER_BASE_DIR/config/main_config.xml</code></p>\n\n<p>This contains general default settings for the chain controller. Each of these can\nbe overridden by the relevant command line options.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Setting</th>\n  <th>Options</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>use_multi_processing</td>\n  <td>true or false</td>\n  <td>if true multi-processing is used</td>\n</tr>\n<tr>\n  <td>max_processes_for_multiprocessing</td>\n  <td>int</td>\n  <td>max number of processes to use for multi-processing</td>\n</tr>\n<tr>\n  <td>use_shared_memory</td>\n  <td>true or false</td>\n  <td>if true allow use of shared memory. Experimental feature</td>\n</tr>\n<tr>\n  <td>stop_on_error</td>\n  <td>true or false</td>\n  <td>stop chain on first error found, or log error and skip</td>\n</tr>\n</tbody>\n</table>\n\n<h3 id=\"chain-specific-configuration\">Chain Specific Configuration</h3>\n\n<p>The default configuration for your chain's algorithms and finder classes should be placed in\nthe chain specific config file:</p>\n\n<p><code>$CLEV2ER_BASE_DIR/config/chain_configs/&lt;chain_name&gt;/&lt;anyname&gt;[.xml,.XML,or .yml]</code></p>\n\n<p>Configuration files may be either XML(.xml) or YAML (.yml) format.</p>\n\n<h4 id=\"formatting-rules-for-chain-configuration-files\">Formatting Rules for Chain Configuration Files</h4>\n\n<p>YAML or XML files can contain multi-level settings for key value pairs of boolean,\nint, float or str.</p>\n\n<ul>\n<li>boolean values must be set to the string <strong>true</strong> or <strong>false</strong> (case insensitive)</li>\n<li>environment variables are allowed within strings as $ENV_NAME or ${ENV_NAME} (and will be\nevaluated)</li>\n<li>YAML or XML files may have multiple levels (or sections)</li>\n<li>XML files must have a top root level named <em>configuration</em>  wrapping the lower levels.\nThis is removed from the python config dictionary before being passed to the algorithms.</li>\n<li>chain configuration files must have a\n<ul>\n<li><strong>log_files</strong> section to provide locations of the log files (see below)</li>\n<li><strong>breakpoint_files</strong> section to provide locations of the log files (see below)</li>\n</ul></li>\n</ul>\n\n<p>Example of sections from a 2 level config file in YML:</p>\n\n<pre><code># some_key: str:  description\nsome_key: a string\n\nsection1:\n    key1: 1\n    key2: 1.5\n    some_data_location: $MYDATA/dem.nc\n\nsection2:\n    key: false\n</code></pre>\n\n<p>Example of sections from a 2 level config file in XML:</p>\n\n<pre><code>&lt;?xml version=\"1.0\"?&gt;\n\n&lt;!-- configuration xml level required, but removed in python dict --&gt;\n&lt;configuration&gt;\n\n&lt;!--some_key: str:  description--&gt;\n&lt;some_key&gt;a string&lt;/some_key&gt;\n\n&lt;section1&gt;\n   &lt;key1&gt;1&lt;/key1&gt;\n   &lt;key2&gt;1.5&lt;/key2&gt;\n   &lt;some_data_location&gt;$MYDATA/dem.nc&lt;/some_data_location&gt;\n&lt;/section1&gt;\n\n&lt;section2&gt;\n   &lt;key&gt;false&lt;/key&gt;\n&lt;/section2&gt;\n\n&lt;/configuration&gt;\n\n</code></pre>\n\n<p>These settings are available within Algorithm classes as a python dictionary called\n<strong>self.config</strong> as in the following examples:</p>\n\n<pre><code>self.config['section1']['key1']\nself.config['section1']['some_data_location']\nself.config['some_key']\n</code></pre>\n\n<p>The config file will also be\nmerged with the main run control dictionary. Settings in the chain configuration\nfile will take precedence over the main run control dictionary (if they are identical), so\nyou can override any main config settings in the named chain config if you want.</p>\n\n<h3 id=\"required-chain-configuration-settings\">Required Chain Configuration Settings</h3>\n\n<p>Each chain configuration file should contain sections to configure logging and breakpoints.\nSee the section on logging below for an explanation of the settings.</p>\n\n<p>Here is a minimal configuration file (XML format)</p>\n\n<pre><code>&lt;?xml version=\"1.0\"?&gt;\n&lt;!--chain: mychain configuration file--&gt;\n\n&lt;configuration&gt; &lt;!-- note this level is removed in python dict --&gt;\n\n&lt;!--Setup default locations to store breakpoint files--&gt;\n&lt;breakpoint_files&gt;\n    &lt;!-- set the default directory where breakpoint files are stored --&gt;\n    &lt;default_dir&gt;/tmp&lt;/default_dir&gt;\n&lt;/breakpoint_files&gt;\n\n&lt;log_files&gt;\n    &lt;!-- default directory to store log files --&gt;\n    &lt;default_dir&gt;/tmp&lt;/default_dir&gt;\n    &lt;!-- info_name : str : file name base str for info files --&gt;\n    &lt;info_name&gt;info&lt;/info_name&gt;\n    &lt;!-- error_name : str : file name base str for errorfiles --&gt;\n    &lt;error_name&gt;error&lt;/error_name&gt;\n    &lt;!-- debug_name : str : file name base str for debug files --&gt;\n    &lt;debug_name&gt;debug&lt;/debug_name&gt;\n    &lt;!-- logname_str : str : additional string to add to end of log filename, before .log\n    Leave empty if mot required\n    --&gt;\n    &lt;logname_str&gt;&lt;/logname_str&gt;\n\n    &lt;!-- append_date_selection : true or false, if year and month are specified on\n    command line append _MMYYYY to log file base name (before .log) --&gt;\n    &lt;append_date_selection&gt;true&lt;/append_date_selection&gt;\n    &lt;append_process_id&gt;false&lt;/append_process_id&gt;\n    &lt;append_start_time&gt;true&lt;/append_start_time&gt;\n&lt;/log_files&gt;\n\n&lt;!-- add more levels and settings below here --&gt;\n\n&lt;resources&gt;\n        &lt;physical_constants&gt;\n\n                &lt;directory&gt;$CLEV2ER_BASE_DIR/testdata/adf/common&lt;/directory&gt;\n                &lt;filename&gt;\nCR__AX_GR_CST__AX_00000000T000000_99999999T999999_20240201T000000__________________CPOM_SIR__V01.NC\n                &lt;/filename&gt;\n                &lt;mandatory&gt;True&lt;/mandatory&gt;\n        &lt;/physical_constants&gt;\n&lt;/resources&gt;\n\n&lt;/configuration&gt;\n\n</code></pre>\n\n<p>The requirement for specific settings are set by the chain and it's algorithms.\nAn example of a chain configuration file can be found at:</p>\n\n<p><code>$CLEV2ER_BASE_DIR/config/chain_configs/testchain/testchain_config.xml</code></p>\n\n<p>For testing purposes it is sometimes useful to modify configuration settings directly\nfrom the command line. This can be done using the command line option --conf_opts which\ncan contain a comma separated list of section:key:value pairs.</p>\n\n<p>An example of changing the value of the setting above would be:</p>\n\n<p>--conf_opts resources:mydata:${MYDATA_DIR}/somedata2.nc</p>\n\n<h2 id=\"developing-new-chains\">Developing New Chains</h2>\n\n<ol>\n<li>Decide on a chain name. For example <strong>newchain</strong></li>\n<li>Create $CLEV2ER_BASE_DIR/algorithms/<strong>newchain</strong>/ directory to store the new chain's algorithms.</li>\n<li>Create $CLEV2ER_BASE_DIR/algorithms/<strong>newchain</strong>/tests to store the new chain's\nalgorithm unit tests (using tests formatted for pytest). At least one algorithm test file\nshould be created per algorithm, which should contain suitable test functions.</li>\n<li>Create your algorithms by copying and renaming the algorithm class template\n$CLEV2ER_BASE_DIR/algorithms/testchain/alg_template1.py in to your algorithm directory. Each\nalgorithm\nshould have a different file name of your choice. For example: alg_retrack.py, alg_geolocate.py.\nYou need to fill in the appropriate sections of the init(), process() and finalize() functions\nfor each algorithm (see section below for more details on using algorithm classes).</li>\n<li>You must also create a test for each algorithm in\n$CLEV2ER_BASE_DIR/algorithms/<strong>newchain</strong>/tests.\nYou should copy/adapt the test template\n$CLEV2ER_BASE_DIR/algorithms/testchain/tests/test_alg_template1.py\nfor your new test.</li>\n<li>Each algorithm and their unit tests must pass the static code checks (pylint, mypy, etc) which\nare automatically run as git pre-commit hooks.</li>\n<li>Create a first XML or YML configuration file for the chain in\n$CLEV2ER_BASE_DIR/config/chain_configs/<strong>newchain</strong>/<strong>anyname</strong>.yml or .xml.\nThe configuration file contains any settings or resource locations that are required\nby your algorithms, and may include environment variables.</li>\n<li>If required create one or more finder class files. These allow fine control of L1b file\nselection from the command line (see section below for more details).</li>\n<li>Create an algorithm list YML file in\n$CLEV2ER_BASE_DIR/config/algorithm_lists/<strong>newchain</strong>/<strong>anyname</strong>.xml (or .yml)\nYou can copy the template\nin <code>$CLEV2ER_BASE_DIR/config/algorithm_lists/testchain/testchain_config.xml</code></li>\n<li>To test your chain on a single L1b file, you can use\n<code>run_chain.py --name newchain -f /path/to/a/l1b_file</code>. There are many other options for\n running chains (see <code>run_chain.py -h</code>).</li>\n</ol>\n\n<h2 id=\"algorithm-and-finder-classes\">Algorithm and Finder Classes</h2>\n\n<p>This section discusses how to develop algorithms for your chain. There are two types\nof algorithms, both of which are dynamically loaded at chain run-time.</p>\n\n<ul>\n<li>Main algorithms : standard chain algorithm classes</li>\n<li>Finder algorithms : optional classes to manage input L1b file selection</li>\n</ul>\n\n<h3 id=\"algorithm-lists\">Algorithm Lists</h3>\n\n<p>Algorithms are dynamically loaded in a chain when (and in the order ) they are named in the chain's\nalgorithm list YAML or XML file:\n$CLEV2ER_BASE_DIR/config/algorithm_lists/**chainname**/**chainname**.yml,.xml.\nThis has two sections (l1b_file_selectors, and algorithms) as shown in the example below:</p>\n\n<p>YML version:</p>\n\n<pre><code># List of L1b selector classes to call in order\nl1b_file_selectors:\n  - find_lrm  # find LRM mode files that match command line options\n  - find_sin  # find SIN mode files that match command line options\n# List of main algorithms to call in order\nalgorithms:\n  - alg_identify_file # find and store basic l1b parameters\n  - alg_skip_on_mode  # finds the instrument mode of L1b, skip SAR files\n  #- alg_...\n</code></pre>\n\n<p>XML version:</p>\n\n<p>The xml version requires an additional toplevel <code>&lt;algorithm_list&gt;</code> that wraps the other sections.\nIt also allows you to enable or disable individual algorithms within the list by setting the\nvalues <em>Enable</em> or <em>Disable</em>, and to set breakpoints by setting the value to <em>BreakpointAfter</em>.</p>\n\n<pre><code>&lt;?xml version=\"1.0\"?&gt;\n\n&lt;algorithm_list&gt;\n    &lt;algorithms&gt;\n        &lt;alg_identify_file&gt;Enable&lt;/alg_identify_file&gt;\n        &lt;alg_skip_on_mode&gt;Enable&lt;/alg_skip_on_mode&gt;\n        &lt;!-- ... more algorithms --&gt;\n        &lt;alg_retrack&gt;BreakpointAfter&lt;/alg_retrack&gt;\n    &lt;/algorithms&gt;\n\n    &lt;l1b_file_selectors&gt;\n        &lt;find_lrm&gt;Enable&lt;/find_lrm&gt;\n        &lt;find_sin&gt;Enable&lt;/find_sin&gt;\n    &lt;/l1b_file_selectors&gt;\n&lt;/algorithm_list&gt;\n\n</code></pre>\n\n<h3 id=\"main-algorithms\">Main Algorithms</h3>\n\n<p>Each algorithm is implemented in a separate module located in</p>\n\n<p><code>$CLEV2ER_BASE_DIR/src/clev2er/algorithms/&lt;chainname&gt;/&lt;alg_name&gt;.py</code></p>\n\n<p>Each algorithm module should contain an Algorithm class, as per the algorithm\ntemplate in:</p>\n\n<p><code>$CLEV2ER_BASE_DIR/src/clev2er/algorithms/testchain/alg_template1.py</code></p>\n\n<p>Please copy this template for all algorithms.</p>\n\n<p>Algorithm class modules have three main functions:</p>\n\n<ul>\n<li><strong>init()</strong> :  used for initializing/loading resources. Called once at the start of processing.</li>\n<li><strong>process</strong>(l1b:Dataset,shared_dict:dict) : called for every L1b file. The results of the\nprocessing may be saved in the shared_dict, so that it can be accessed by algorithms called\nfurther down the chain. The L1b data for the current file being processed is passed to this\nfunction in a netcdf4 Dataset as argument l1b.</li>\n<li><strong>finalize</strong>() : called at the end of all processing to free resouces.</li>\n</ul>\n\n<p>All of the functions have access to the merged chain configuration dictionary <strong>self.config</strong>.</p>\n\n<p>All logging must be done using <strong>self.log</strong>.info(), <strong>self.log</strong>.error(), <strong>self.log</strong>.debug().</p>\n\n<h4 id=\"algorithmprocess-return-values\">Algorithm.process() return values</h4>\n\n<p>It is important to note that Algorithm.<strong>process()</strong> return values affect how the\nchain operates. The .process() function returns (bool, str).</p>\n\n<p>Return values must be set as follows:</p>\n\n<ul>\n<li>(<strong>True</strong>,\"\") when the processing has completed without errors and continuation to the\nnext algorithm in the chain (if available) is expected.</li>\n<li>(<strong>False</strong>,\"<strong>SKIP_OK</strong> any reason message\") when the processing has found a valid reason for the\nchain to skip any further processing of the L1b file. For example if it does not measure over the\ntarget area. This will be logged as DEBUG message but is not an error. The chain will move to\nprocessing the next L1b file.</li>\n<li>(<strong>False</strong>,\"some error message\") : In this case the error message will be logged to the error log\nand the file will be skipped. If <strong>config</strong>[\"chain\"][\"<strong>stop_on_error</strong>\"] is False then the\nchain will continue to the next L1b file. If <strong>config</strong>[\"chain\"][\"<strong>stop_on_error</strong>\"] is True,\nthen the chain will stop.</li>\n</ul>\n\n<h3 id=\"filefinder-classes\">FileFinder Classes</h3>\n\n<p>FileFinder class modules provide more complex and tailored L1b input file selection\nthan would be possible with the standard <strong>run_chain.py</strong> command line options of :</p>\n\n<ul>\n<li>(<strong>--file path</strong>) : choose single L1b file</li>\n<li>(<strong>--dir dir</strong>) : choose all L1b files in a flat directory</li>\n</ul>\n\n<p>FileFinder classes are only used as the file selection method if the --file and --dir\ncommand line options are <strong>not</strong> used.</p>\n\n<p>For example you may wish to select files using a specific search pattern, or from multiple\ndirectories.</p>\n\n<p>FileFinder classes are automatically initialized with :</p>\n\n<ul>\n<li><strong>self.config</strong> dict from the merged chain dict, any settings can be used for file selection</li>\n<li><strong>self.months</strong> (from command line option --month, if used)</li>\n<li><strong>self.years</strong> (from command line option --year, if used)</li>\n</ul>\n\n<p>FileFinder classes return a list of file paths through their .find_files() function.\nCode needs to be added to the .find_files() function to generate the file list.</p>\n\n<p>Any number of differently named FileFinder class modules can be specified in the algorithm list\nfile,\nunder the <strong>l1b_file_selectors:</strong> section. File lists are concatentated if more than one Finder\nclass is used.</p>\n\n<p>An example of a FileFinder class module can be found in:</p>\n\n<p><code>clev2er.algorithms.cryotempo.find_lrm.py</code></p>\n\n<h2 id=\"logging\">Logging</h2>\n\n<p>Logging within the chain is performed using the python standard logging.Logger mechanism\nbut with some minor adaption to support multi-processing.</p>\n\n<p>Within algorithm modules, logging should be performed using the in-class Logger\ninstance accessed using <strong>self.</strong>log :</p>\n\n<ul>\n<li>self.log.<strong>info</strong>('message') : to log informational messages</li>\n<li>self.log.<strong>error</strong>('message') : to log error messages</li>\n<li>self.log.<strong>debug</strong>('message') : to log messages for debugging</li>\n</ul>\n\n<p>Debugging messages are only produced/saved if the chain is run in debug mode (use\nrun_chain.py <strong>--debug</strong> command line option)</p>\n\n<h3 id=\"log-file-locations\">Log file Locations</h3>\n\n<p>Info, error, and debug logs are stored in separate log files. The locations\nof the log files are set in the chain configuration file in a section called\n<strong>log_files</strong>. You can use environment variables in your log file paths.</p>\n\n<pre><code># Default locations for log files\nlog_files:\n  append_year_month_to_logname: true\n  errors: ${CT_LOG_DIR}/errors.log\n  info:   ${CT_LOG_DIR}/info.log\n  debug:  ${CT_LOG_DIR}/debug.log\n</code></pre>\n\n<p>The <strong>append_year_month_to_logname</strong> setting is used if the chain is\nrun with the --year (and/or) --month command line args. Note that these\ncommand line options are passed to the optional finder classes to generate a\nlist of L1b input files.</p>\n\n<p>If these are used and the append_year_month_to_logname setting is <strong>true</strong>,\nthen the year and month are appended to the log file names as follows:</p>\n\n<ul>\n<li><em>logname</em>_<em>MMYYYY</em>.log : if both month and year are specified</li>\n<li><em>logname</em>_<em>YYYY</em>.log : if only year is used</li>\n</ul>\n\n<h3 id=\"logging-when-using-multi-processing\">Logging when using Multi-Processing</h3>\n\n<p>When multi-processing mode is selected then logged messages are automatically passed\nthrough a pipe to a temporary file (<em>logfilename</em>.mp). This will\ncontain an unordered list of messages from all processes, which is difficult\nto read directly.</p>\n\n<p>At the end of the chain run the multi-processing log outputs are automatically sorted\nso that messages relating to each L1b file processing are collected together\nin order. This is then merged in to the main log file.</p>\n\n<h2 id=\"breakpoint-files\">Breakpoint Files</h2>\n\n<h6 id=\"breakpoints-can-be-set-after-any-algorithm-by\">Breakpoints can be set after any Algorithm by:</h6>\n\n<blockquote>\n  <ul>\n  <li>setting the <em>BreakpointAfter</em> value in the chain's Algorithm list, or</li>\n  <li>using the run_chain.py command line argument **--breakpoint_after** *algorithm_name*</li>\n  </ul>\n</blockquote>\n\n<h6 id=\"when-a-breakpoint-is-set\">When a breakpoint is set:</h6>\n\n<blockquote>\n  <ul>\n  <li>the chain will stop after the specified algorithm has completed for each input file.</li>\n  <li>the contents of the chain's <em>shared_dict</em> will be saved as a NetCDF4 file in the\n  <code>&lt;breakpoint_dir&gt;</code> as specified in the <em>breakpoints:default_dir</em> section in the chain\n  configuration file.</li>\n  <li>the NetCDF4 file will be named as <code>&lt;breakpoint_dir&gt;/&lt;l1b_file_name&gt;_bkp.nc</code></li>\n  <li>if multiple L1b files are being processed through the chain, a breakpoint file\n  will be created for each.</li>\n  <li>single values or strings in the <em>shared_dict</em> will be included as global or group\n  NetCDF attributes.</li>\n  <li>if there are multiple levels in the <em>shared_dict</em> then a NetCDF group will be\n  created for each level.</li>\n  <li>multi-dimensional arrays (or numpy arrays) are supported up to dimension 3.</li>\n  <li>NetCDF dimension variables will not be named with physical meaning (ie time),\n  as this information can not be generically derived. Instead dimensions will be\n  named dim1, dim2, etc.</li>\n  <li>all variables with the same dimension will share a common NetCDF dimension (ie dim1, etc)</li>\n  </ul>\n</blockquote>\n\n<h2 id=\"developer-notes\">Developer Notes</h2>\n\n<h3 id=\"code-checks-before-committing\">Code checks before committing</h3>\n\n<p>It is recommended to run pre-commit before a <code>git commit</code>. This runs the static\ncode analysis tests (isort, pylint, ruff, mypy,.. ) on your code and shows you any\nfailures before you commit. The same tests are also run when you commit (and must pass).</p>\n\n<p><code>precommit run --all</code></p>\n\n<h3 id=\"pytest-markers\">Pytest Markers</h3>\n\n<p>Pytest markers are setup in $CLEV2ER_BASE_DIR/pytest.ini</p>\n\n<p>It is important to use the correct pytest marker due to the use of GitHub CI\nworkflows that run pytest on the whole repository source code. Some pytest\ntests are not suitable for GitHub CI workflow runs due to their large external\ndata dependencies. These need to be marked with <code>pytest.mark.requires_external_data</code>\nso that they are skipped. These tests can be run locally where access to the data\nis available.</p>\n\n<p>The following Pytest markers should be used in front of relevant pytest functions:</p>\n\n<ul>\n<li><strong>requires_external_data</strong>:\ntestable on local systems with access to all external data/ADF (outside repo)</li>\n<li><strong>non_core</strong>:\nused to label non-core function tests such as area plotting functions</li>\n</ul>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@pytest</span><span class=\"o\">.</span><span class=\"n\">mark</span><span class=\"o\">.</span><span class=\"n\">requires_external_data</span>  <span class=\"c1\"># not testable on GitHub due to external data</span>\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">test_alg_lig_process_large_dem</span><span class=\"p\">(</span><span class=\"n\">l1b_file</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n</code></pre>\n</div>\n\n<p>or placed at the top of a module:</p>\n\n<p><code>pytestmark = pytest.mark.non_core</code></p>\n\n<h3 id=\"github-pages-documentation-from-in-code-docstrings\">GitHub Pages Documentation from in-code Docstrings</h3>\n\n<p>This user manual is hosted on GitHub pages (<a href=\"https://mssl-softeng.github.io/clev2er_sii\">https://mssl-softeng.github.io/clev2er_sii</a>)</p>\n\n<p>Content is created from doctrings\n(optionally containing Markdown: <a href=\"https://www.markdownguide.org/basic-syntax/#code\">https://www.markdownguide.org/basic-syntax/#code</a> )\nin the code,\nusing the <em>pdoc</em> package : <a href=\"https://pdoc.dev\">https://pdoc.dev</a></p>\n\n<p>Diagrams can be implemented using mermaid: <a href=\"https://mermaid.js.org\">https://mermaid.js.org</a></p>\n\n<p>The site is locally built in <code>$CLEV2ER_BASE_DIR/docs</code>, using a pre-commit hook\n(hook id: pdocs_build).\nHooks are configured in <code>$CLEV2ER_BASE_DIR/.pre-commit-config.yaml</code></p>\n\n<p>The hook calls the script <code>$CLEV2ER_BASE_DIR/pdocs_build.sh</code> to build the site\nwhenever a <code>git commit</code> is run <strong>in branch gh_pages</strong>.</p>\n\n<p>When a <code>git push</code> is run, GitHub automatically extracts the site from the\ndocs directory and publishes it.</p>\n\n<p>The front page of the site (ie this page) is located in the doctring within\n<code>$CLEV2ER_BASE_DIR/src/clev2er/__init__.py</code>.</p>\n\n<p>The docstring within <code>__init__.py</code> of each package directory should provide\nmarkdown to describe the directories beneath it.</p>\n\n<h4 id=\"process-to-update-docs\">Process to Update Docs</h4>\n\n<p>One method of updating the GitHub Pages documentation from the code (ie\nto process the docstrings in to html in the /docs folder)</p>\n\n<ul>\n<li>Edit docstrings in master branch code (or by pull request from other branch)</li>\n<li>git commit -a -m \"docs update\"</li>\n<li>git checkout gh_pages</li>\n<li>git merge master</li>\n<li>pre-commit run --all (runs pdocs to update the html in docs folder)</li>\n<li>git commit -a -m \"docs update\"</li>\n<li>git push</li>\n<li>git checkout master  (return to master branch)</li>\n<li>git merge gh_pages</li>\n<li>git push</li>\n</ul>\n\n<p>Why isn't this run automatically from the master branch or in a GitHub workflow?\nThis is because pdocs (part of the pre-commit hooks) requires all code dependencies\nto be in place, including external data, when parsing/importing the code.\nExternal data is not available on GitHub, and also on some minimal installations\nof the master branch. So, to avoid pre-commit failing due to pdocs on other\nbranches, or GitHub workflows doing the same, the docs are only updated on a\ncontrolled 'gh_pages' branch (which has all external data installed).</p>\n"}, {"fullname": "clev2er.algorithms", "modulename": "clev2er.algorithms", "kind": "module", "doc": "<h2 id=\"algorithm-directories\">Algorithm Directories</h2>\n\n<p>The clev2er -> <strong>algorithms</strong> dir contains sub-directories for each chain.</p>\n\n<p>For example:  <code>clev2er.algorithms.landice</code></p>\n\n<p>in this case <strong>landice</strong> is the chain name and the <em>landice</em> directory contains\nalgorithms for its chain.</p>\n\n<h2 id=\"templates-directory\">Templates directory</h2>\n\n<p>The <code>clev2er.algorithms.testchain</code> directory contains a template algorithms to be copied for\nnew chain algorithms.</p>\n"}, {"fullname": "clev2er.algorithms.base", "modulename": "clev2er.algorithms.base", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.algorithms.base.base_alg", "modulename": "clev2er.algorithms.base.base_alg", "kind": "module", "doc": "<p>clev2er.algorithms.base.base_alg</p>\n"}, {"fullname": "clev2er.algorithms.base.base_alg.AlgorithmError", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "AlgorithmError", "kind": "class", "doc": "<p>Custom exception class to handle specific application errors.</p>\n", "bases": "builtins.Exception"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm", "kind": "class", "doc": "<p><strong>Algorithm to do...</strong>.</p>\n\n<p><strong>Contribution to shared dictionary</strong></p>\n\n<pre><code>- shared_dict['param'] : (type), param description\n</code></pre>\n", "bases": "abc.ABC"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm.__init__", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm.__init__", "kind": "function", "doc": "<p>Runs init() if not in multi-processing mode</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config (dict):</strong>  configuration dictionary</li>\n<li><strong>log (logging.Logger):</strong>  initial log instance to use for this algorithm</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>None</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">thislog</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">|</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm.init", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm.init", "kind": "function", "doc": "<p>Algorithm initialization template</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(bool,str) : success or failure, error string</p>\n</blockquote>\n\n<p>Note: raise and Exception rather than just returning False</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm.set_log", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm.set_log", "kind": "function", "doc": "<p>function to set the logger to use within this algorithm</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>log (logging.Logger):</strong>  assign the logging instance to use for this algorithm</li>\n</ul>\n\n<p>Returns: None</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">thislog</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm.set_filenum", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm.set_filenum", "kind": "function", "doc": "<p>set the current file number (0..(max_files-1))</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>filenum (int):</strong>  current file number being processed</li>\n</ul>\n\n<p>Returns: None</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filenum</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm.process_setup", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm.process_setup", "kind": "function", "doc": "<p>common pre-processor which tests the L1b Dataset is valid\n   and also runs BaseAlgorithm.init() if in multi-processing mode\n   This should be run as a first step inside Algorithm.process()</p>\n\n<pre><code>`success, error_str = self.process_setup(l1b)`\n</code></pre>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b (Dataset):</strong>  input l1b file dataset (constant)</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple : (success (bool), failure_reason (str))\n  ie\n  (False,'error string'), or (True,'')</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">l1b</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm.process", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm.process", "kind": "function", "doc": "<p>Main algorithm processing function, called for every L1b file</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b (Dataset):</strong>  input l1b file dataset (constant)</li>\n<li><strong>shared_dict (dict):</strong>  shared_dict data passed between algorithms. Use this dict\nto pass algorithm results down the chain or read variables\nset by other algorithms.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple : (success (bool), failure_reason (str))\n  ie\n  (False,'error string'), or (True,'')</p>\n</blockquote>\n\n<p>Note:</p>\n\n<ul>\n<li>retrieve required config data from self.config dict (read-only)</li>\n<li>retrieve data from other algorithms from shared_dict</li>\n<li>add results,variables from this algorithm to shared_dict</li>\n<li>log using self.log.info(), or self.log.error() or self.log.debug()</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">l1b</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">shared_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_alg.BaseAlgorithm.finalize", "modulename": "clev2er.algorithms.base.base_alg", "qualname": "BaseAlgorithm.finalize", "kind": "function", "doc": "<p>Perform final clean up actions for algorithm</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stage (int, optional):</strong>  Can be set to track at what stage the</li>\n<li>finalize() function was called</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stage</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_finder", "modulename": "clev2er.algorithms.base.base_finder", "kind": "module", "doc": "<p>clev2er.algorithms.base.base_finder</p>\n"}, {"fullname": "clev2er.algorithms.base.base_finder.BaseFinder", "modulename": "clev2er.algorithms.base.base_finder", "qualname": "BaseFinder", "kind": "class", "doc": "<p>Base class to find a list of L1b files</p>\n\n<p>Raises: FileNotFoundError : if base_path is not a valid directory</p>\n"}, {"fullname": "clev2er.algorithms.base.base_finder.BaseFinder.__init__", "modulename": "clev2er.algorithms.base.base_finder", "qualname": "BaseFinder.__init__", "kind": "function", "doc": "<p>class initialization function</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "clev2er.algorithms.base.base_finder.BaseFinder.add_month", "modulename": "clev2er.algorithms.base.base_finder", "qualname": "BaseFinder.add_month", "kind": "function", "doc": "<p>Add to list of month numbers to load</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>month (list[int]):</strong>  month numbers</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">months</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_finder.BaseFinder.add_year", "modulename": "clev2er.algorithms.base.base_finder", "qualname": "BaseFinder.add_year", "kind": "function", "doc": "<p>Add to list of year numbers to load</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>year (List[int]):</strong>  list of year numbers in YYYY</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">years</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.base_finder.BaseFinder.find_files", "modulename": "clev2er.algorithms.base.base_finder", "qualname": "BaseFinder.find_files", "kind": "function", "doc": "<p>Search for L1b file according to pattern</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>flat_search (bool) :</strong>  if True only search in self.base_path, else use pattern</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(str): list of files</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">flat_search</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.base.tests", "modulename": "clev2er.algorithms.base.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.algorithms.base.tests.test_finders", "modulename": "clev2er.algorithms.base.tests.test_finders", "kind": "module", "doc": "<p>test_finders.py</p>\n"}, {"fullname": "clev2er.algorithms.base.tests.test_finders.FileFinder", "modulename": "clev2er.algorithms.base.tests.test_finders", "qualname": "FileFinder", "kind": "class", "doc": "<p>class to return a list of L1b files</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>BaseFinder (BaseFinder):</strong>  base finder class</li>\n</ul>\n\n<p>In order to find files you can optionally use the following\nwhich are optionally set by the run_chain.py command line parameters</p>\n\n<h6 id=\"set-by-command-line-options\">Set by command line options:</h6>\n\n<blockquote>\n  <p>self.months  # list of months to find\n  self.years   # list of years to find</p>\n</blockquote>\n\n<h6 id=\"set-by-config-file-settings\">Set by config file settings:</h6>\n\n<blockquote>\n  <p>config[\"l1b_base_dir\"]</p>\n</blockquote>\n", "bases": "clev2er.algorithms.base.base_finder.BaseFinder"}, {"fullname": "clev2er.algorithms.base.tests.test_finders.FileFinder.find_files", "modulename": "clev2er.algorithms.base.tests.test_finders", "qualname": "FileFinder.find_files", "kind": "function", "doc": "<p>find list of L1b files</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>flat_search (bool, optional):</strong>  _description_. Defaults to False.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>KeyError:</strong>  _description_</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[str]: _description_</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">flat_search</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.templates", "modulename": "clev2er.algorithms.templates", "kind": "module", "doc": "<p>This directory contains <em>algorithm template.py</em> which should be the <em>basis</em> for\nall new algorithms in the CLEV2ER project.</p>\n\n<p>The <code>clev2er.algorithms.templates.algorithm_template.Algorithm</code> class contains the \ntemplate algorithm code.</p>\n\n<p>The <code>clev2er.algorithms.templates.algorithm_template.test</code> module contains \nthe unit tests for the algorithm template code.</p>\n"}, {"fullname": "clev2er.algorithms.templates.tests", "modulename": "clev2er.algorithms.templates.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.algorithms.testchain", "modulename": "clev2er.algorithms.testchain", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.algorithms.testchain.alg_template1", "modulename": "clev2er.algorithms.testchain.alg_template1", "kind": "module", "doc": "<p>clev2er.algorithms.testchain.alg_template1.py</p>\n\n<p>Algorithm class module, used to implement a single chain algorithm</p>\n\n<h1 id=\"description-of-this-algorithms-purpose\">Description of this Algorithm's purpose</h1>\n\n<p>This is an example Algorithm which should be used as a template\nfor other Algorithm modules.</p>\n\n<p>As an example this Algorithm adds a parameter to the shared_dict\nas shared_dict[\"ocean_tide_01\"]</p>\n\n<h1 id=\"main-initialization-init-function-stepsresources-required\">Main initialization (init() function) steps/resources required</h1>\n\n<p>None</p>\n\n<h1 id=\"main-process-function-steps\">Main process() function steps</h1>\n\n<p>adds some data to the shared_dict</p>\n\n<h1 id=\"contribution-to-shared_dict\">Contribution to shared_dict</h1>\n\n<p>shared_dict[\"ocean_tide_01\"] (np.array[int]) : example data</p>\n\n<h1 id=\"requires-from-shared_dict\">Requires from shared_dict</h1>\n\n<p>None</p>\n"}, {"fullname": "clev2er.algorithms.testchain.alg_template1.Algorithm", "modulename": "clev2er.algorithms.testchain.alg_template1", "qualname": "Algorithm", "kind": "class", "doc": "<p>CLEV2ER Algorithm class</p>\n\n<p>contains:\n     .log (Logger) : log instance that must be used for all logging, set by BaseAlgorithm\n     .config (dict) : configuration dictionary, set by BaseAlgorithm\n     - functions that need completing:\n     .init() : Algorithm initialization function (run once at start of chain)\n     .process(l1b,shared_dict) : Algorithm processing function (run on every L1b file)\n     .finalize() : Algorithm finalization/closure function (run after all chain\n                   processing completed)</p>\n\n<p>Inherits from BaseAlgorithm which handles interaction with the chain controller run_chain.py</p>\n", "bases": "clev2er.algorithms.base.base_alg.BaseAlgorithm"}, {"fullname": "clev2er.algorithms.testchain.alg_template1.Algorithm.init", "modulename": "clev2er.algorithms.testchain.alg_template1", "qualname": "Algorithm.init", "kind": "function", "doc": "<p>Algorithm initialization function</p>\n\n<p>Add steps in this function that are run once at the beginning of the chain\n(for example loading a DEM or Mask)</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(bool,str) : success or failure, error string</p>\n</blockquote>\n\n<p>Test for KeyError or OSError exceptions and raise them if found\nrather than just returning (False,\"error description\")</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>KeyError :</strong>  for keys not found in self.config</li>\n<li><strong>OSError :</strong>  for any file related errors</li>\n</ul>\n\n<p>Note:</p>\n\n<ul>\n<li>retrieve required config data from self.config dict</li>\n<li>log using self.log.info(), or self.log.error() or self.log.debug()</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.testchain.alg_template1.Algorithm.process", "modulename": "clev2er.algorithms.testchain.alg_template1", "qualname": "Algorithm.process", "kind": "function", "doc": "<p>Main algorithm processing function, called for every L1b file</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b (Dataset):</strong>  input l1b file dataset (constant)</li>\n<li><strong>shared_dict (dict):</strong>  shared_dict data passed between algorithms. Use this dict\nto pass algorithm results down the chain or read variables\nset by other algorithms.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple : (success (bool), failure_reason (str))\n  ie\n  (False,'error string'), or (True,'')</p>\n</blockquote>\n\n<p>Note:</p>\n\n<ul>\n<li>retrieve required config data from self.config dict (read-only)</li>\n<li>retrieve data from other algorithms from shared_dict</li>\n<li>add results,variables from this algorithm to shared_dict</li>\n<li>log using self.log.info(), or self.log.error() or self.log.debug()</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">l1b</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">shared_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.testchain.alg_template1.Algorithm.finalize", "modulename": "clev2er.algorithms.testchain.alg_template1", "qualname": "Algorithm.finalize", "kind": "function", "doc": "<p>Algorithm finalization function - called after all processing completed</p>\n\n<p>Can be used to clean up/free resources initialized in the init() function</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stage (int, optional):</strong>  this sets the stage when this function is called\nby the chain controller. Useful during multi-processing.\nDefaults to 0. Not normally used by Algorithms.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stage</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.testchain.alg_template2", "modulename": "clev2er.algorithms.testchain.alg_template2", "kind": "module", "doc": "<p>clev2er.algorithms.testchain.alg_template2.py</p>\n\n<p>Algorithm class module, used to implement a single chain algorithm</p>\n\n<h1 id=\"description-of-this-algorithms-purpose\">Description of this Algorithm's purpose</h1>\n\n<p>This is an example Algorithm which should be used as a template\nfor other Algorithm modules.</p>\n\n<h1 id=\"main-initialization-init-function-stepsresources-required\">Main initialization (init() function) steps/resources required</h1>\n\n<p>None</p>\n\n<h1 id=\"main-process-function-steps\">Main process() function steps</h1>\n\n<p>adds some data to the shared_dict</p>\n\n<h1 id=\"contribution-to-shared_dict\">Contribution to shared_dict</h1>\n\n<p>shared_dict[\"dummy_parameter\"] (np.array[int]) : example data</p>\n\n<h1 id=\"requires-from-shared_dict\">Requires from shared_dict</h1>\n\n<p>None</p>\n"}, {"fullname": "clev2er.algorithms.testchain.alg_template2.Algorithm", "modulename": "clev2er.algorithms.testchain.alg_template2", "qualname": "Algorithm", "kind": "class", "doc": "<p>CLEV2ER Algorithm class</p>\n\n<p>contains:\n     .log (Logger) : log instance that must be used for all logging, set by BaseAlgorithm\n     .config (dict) : configuration dictionary, set by BaseAlgorithm\n     - functions that need completing:\n     .init() : Algorithm initialization function (run once at start of chain)\n     .process(l1b,shared_dict) : Algorithm processing function (run on every L1b file)\n     .finalize() : Algorithm finalization/closure function (run after all chain\n                   processing completed)</p>\n\n<p>Inherits from BaseAlgorithm which handles interaction with the chain controller run_chain.py</p>\n", "bases": "clev2er.algorithms.base.base_alg.BaseAlgorithm"}, {"fullname": "clev2er.algorithms.testchain.alg_template2.Algorithm.init", "modulename": "clev2er.algorithms.testchain.alg_template2", "qualname": "Algorithm.init", "kind": "function", "doc": "<p>Algorithm initialization function</p>\n\n<p>Add steps in this function that are run once at the beginning of the chain\n(for example loading a DEM or Mask)</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(bool,str) : success or failure, error string</p>\n</blockquote>\n\n<p>Test for KeyError or OSError exceptions and raise them if found\nrather than just returning (False,\"error description\")</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>KeyError :</strong>  for keys not found in self.config</li>\n<li><strong>OSError :</strong>  for any file related errors</li>\n</ul>\n\n<p>Note:</p>\n\n<ul>\n<li>retrieve required config data from self.config dict</li>\n<li>log using self.log.info(), or self.log.error() or self.log.debug()</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.testchain.alg_template2.Algorithm.process", "modulename": "clev2er.algorithms.testchain.alg_template2", "qualname": "Algorithm.process", "kind": "function", "doc": "<p>Main algorithm processing function, called for every L1b file</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b (Dataset):</strong>  input l1b file dataset (constant)</li>\n<li><strong>shared_dict (dict):</strong>  shared_dict data passed between algorithms. Use this dict\nto pass algorithm results down the chain or read variables\nset by other algorithms.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple : (success (bool), failure_reason (str))\n  ie\n  (False,'error string'), or (True,'')</p>\n</blockquote>\n\n<p>Note:</p>\n\n<ul>\n<li>retrieve required config data from self.config dict (read-only)</li>\n<li>retrieve data from other algorithms from shared_dict</li>\n<li>add results,variables from this algorithm to shared_dict</li>\n<li>log using self.log.info(), or self.log.error() or self.log.debug()</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">l1b</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">shared_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.testchain.alg_template2.Algorithm.finalize", "modulename": "clev2er.algorithms.testchain.alg_template2", "qualname": "Algorithm.finalize", "kind": "function", "doc": "<p>Algorithm finalization function - called after all processing completed</p>\n\n<p>Can be used to clean up/free resources initialized in the init() function</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stage (int, optional):</strong>  this sets the stage when this function is called\nby the chain controller. Useful during multi-processing.\nDefaults to 0. Not normally used by Algorithms.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stage</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.testchain.tests", "modulename": "clev2er.algorithms.testchain.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.algorithms.testchain.tests.test_alg_template1", "modulename": "clev2er.algorithms.testchain.tests.test_alg_template1", "kind": "module", "doc": "<p>Test of clev2er.utils.testing.testing.initialize_algorithms</p>\n"}, {"fullname": "clev2er.algorithms.testchain.tests.test_alg_template1.test_alg_template1", "modulename": "clev2er.algorithms.testchain.tests.test_alg_template1", "qualname": "test_alg_template1", "kind": "function", "doc": "<p>pytest of clev2er.utils.testing.testing.initialize_algorithms</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b_file (str) :</strong>  name of L1b file in $CLEV2ER_BASE_DIR/testdata/cristal/l1b/simulated</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">l1b_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.algorithms.testchain.tests.test_alg_template2", "modulename": "clev2er.algorithms.testchain.tests.test_alg_template2", "kind": "module", "doc": "<p>Test of clev2er.utils.testing.testing.initialize_algorithms</p>\n"}, {"fullname": "clev2er.algorithms.testchain.tests.test_alg_template2.test_alg_template2", "modulename": "clev2er.algorithms.testchain.tests.test_alg_template2", "qualname": "test_alg_template2", "kind": "function", "doc": "<p>pytest of clev2er.utils.testing.testing.initialize_algorithms</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b_file (str) :</strong>  name of L1b file in $CLEV2ER_BASE_DIR/testdata/cristal/l1b/simulated</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">l1b_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools", "modulename": "clev2er.tools", "kind": "module", "doc": "<h2 id=\"tools-directory\">Tools Directory</h2>\n\n<p>This directory contains command-line tools required to run the chains.</p>\n\n<h3 id=\"tools-list\">Tools List</h3>\n\n<ul>\n<li><code>clev2er.tools.run_chain</code></li>\n</ul>\n\n<h3 id=\"example-of-running-the-chain\">Example of Running the Chain</h3>\n\n<p>This example runs the processing chain <em>cryotempo</em> on every L1b file in \n/path/to/l1b_files. It uses all the default configuration files for that chain.</p>\n\n<pre><code>cd $CLEV2ER_BASE_DIR/src/clev2er/tools\npython run_chain.py --name cryotempo -d /path/to/l1b_files\n</code></pre>\n\n<p>To find all the current command line options for <em>run_chain.py</em>, type:  </p>\n\n<p><code>run_chain.py --help</code></p>\n\n<table>\n<thead>\n<tr>\n  <th>Argument</th>\n  <th>Short Arg</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>--name</td>\n  <td>-n</td>\n  <td>name (str) : chain name</td>\n</tr>\n<tr>\n  <td>--alglist</td>\n  <td>-a</td>\n  <td>[Optional, str] path of algorithm list YML file. Default is ${CLEV2ER_BASE_DIR}/config/algorithm_lists/<em>chainname</em>.yml</td>\n</tr>\n<tr>\n  <td>--conf</td>\n  <td>-c</td>\n  <td>[Optional, str] path of main XML configuration file. Default is $CLEV2ER_BASE_DIR/config/main_config.xml</td>\n</tr>\n<tr>\n  <td>--baseline</td>\n  <td>-b</td>\n  <td>[Optional, char] baseline of chain. Single uppercase char. Default=A. Used to specify the chain config file, where config file = $CLEV2ER_BASE_DIR/config/chain_configs/*chainname*_<em>BVVV</em>.yml</td>\n</tr>\n<tr>\n  <td>--version</td>\n  <td>-v</td>\n  <td>[Optional, char] version of chain. integer 1-100. Default=1. Used to specify the chain config file, where config file = $CLEV2ER_BASE_DIR/config/chain_configs/*chainname*_<em>BVVV</em>.yml</td>\n</tr>\n<tr>\n  <td>--file</td>\n  <td>-f</td>\n  <td>[Optional, str] path of input L1b file</td>\n</tr>\n<tr>\n  <td>--dir</td>\n  <td>-d</td>\n  <td>[Optional, str] path of dir containing input L1b files</td>\n</tr>\n<tr>\n  <td>--max_files</td>\n  <td>-mf</td>\n  <td>[Optional, int] limit number of L1b files input to first n</td>\n</tr>\n<tr>\n  <td>--quiet</td>\n  <td>-q</td>\n  <td>[Optional] do not output log messages to stdout</td>\n</tr>\n<tr>\n  <td>--debug</td>\n  <td>-de</td>\n  <td>[Optional] log.DEBUG messages are output to log file, and stdout</td>\n</tr>\n<tr>\n  <td>--multiprocessing</td>\n  <td>-mp</td>\n  <td>[Optional] use multi-processing, overrides main config file setting</td>\n</tr>\n<tr>\n  <td>--sequentialprocessing</td>\n  <td>-sp</td>\n  <td>[Optional] use sequential processing, overrides main config file setting</td>\n</tr>\n<tr>\n  <td>--nprocs</td>\n  <td>-np</td>\n  <td>[Optional,int] maximum number of cores to split multi-processing on. Overrides setting in main config</td>\n</tr>\n<tr>\n  <td>--sharedmem</td>\n  <td>-sm</td>\n  <td>[Optional] use shared memory when multi-processing is enabled. Experimental feature</td>\n</tr>\n<tr>\n  <td>--stop_on_error</td>\n  <td>-st</td>\n  <td>[Optional] stop chain on first error. Default is set in main config file</td>\n</tr>\n<tr>\n  <td>--logstring</td>\n  <td>-ls</td>\n  <td>[Optional, str] append this string to log file names for this run, as <logfilename>_<this_string>.log</td>\n</tr>\n<tr>\n  <td>--year</td>\n  <td>-y</td>\n  <td>[Optional, int] year number (YYYY) to use to select L1b files. The year number is used by the chain's finder</td>\n</tr>\n<tr>\n  <td>--month</td>\n  <td>-m</td>\n  <td>[Optional, int] month number (1,12) to use to select L1b files. The month number is used by the chain's finder algorithms if they support month selections</td>\n</tr>\n<tr>\n  <td>--conf_opts</td>\n  <td>-co</td>\n  <td>[Optional, str,str,..]  Comma separated list of key:key:value pairs to pass to the chain. The number of keys is dependent on the configuration levels. If value is a boolean then use key:true or key:false. Single level keys without a value equate to true. Example that changes two settings: -co chain:use_multi_processing:false,lrm_only</td>\n</tr>\n<tr>\n  <td>--cs2testdir</td>\n  <td>-ct</td>\n  <td>[Optional] for quick CS2 tests, uses default CS2 L1b directory: $CLEV2ER_BASE_DIR/testdata/cs2/l1bfiles</td>\n</tr>\n</tbody>\n</table>\n"}, {"fullname": "clev2er.tools.modify_l1b_ku_to_ka", "modulename": "clev2er.tools.modify_l1b_ku_to_ka", "kind": "module", "doc": "<p>tool to create a copy of CRISTAL HR L1b file and copy all ku params to ka</p>\n"}, {"fullname": "clev2er.tools.modify_l1b_ku_to_ka.replicate_ku_into_ka", "modulename": "clev2er.tools.modify_l1b_ku_to_ka", "qualname": "replicate_ku_into_ka", "kind": "function", "doc": "<p>Create a copy of <code>input_nc</code> at <code>output_nc</code> and overwrite data/ka/* variables\nwith data read from data/ku/*.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_nc</span>, </span><span class=\"param\"><span class=\"n\">output_nc</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.modify_l1b_ku_to_ka.main", "modulename": "clev2er.tools.modify_l1b_ku_to_ka", "qualname": "main", "kind": "function", "doc": "<p>main function of tool</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">args</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms", "modulename": "clev2er.tools.plot_waveforms", "kind": "module", "doc": "<p>cpom.altimetry.tools.plot_waveforms.py</p>\n\n<h1 id=\"tool-to-plot-altimetry-waveforms-directly-supports\">Tool to plot altimetry waveforms. Directly supports:</h1>\n\n<p>CRISTAL L1b\nCS2 L1b</p>\n\n<ul>\n<li>any NetCDF file that has selectable latitude, longitude and waveform parameters</li>\n</ul>\n"}, {"fullname": "clev2er.tools.plot_waveforms.get_scaled_font_size", "modulename": "clev2er.tools.plot_waveforms", "qualname": "get_scaled_font_size", "kind": "function", "doc": "<p>Calculate a dynamically scaled font size based on the length of the file name.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_name (str):</strong>  The file name to scale the font size for.</li>\n<li><strong>max_len (int, optional):</strong>  The maximum length for scaling. Defaults to 50.</li>\n<li><strong>base_size (int, optional):</strong>  The base font size. Defaults to 16.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>int: The calculated font size.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">max_len</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">base_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">16</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms.get_projection_and_extent", "modulename": "clev2er.tools.plot_waveforms", "qualname": "get_projection_and_extent", "kind": "function", "doc": "<p>Determine the appropriate Cartopy projection and extent based on latitude.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lat (float):</strong>  The latitude to determine the projection for.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple[ccrs.Projection, list[float] | None]: The Cartopy projection and the extent.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lat</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">cartopy</span><span class=\"o\">.</span><span class=\"n\">crs</span><span class=\"o\">.</span><span class=\"n\">Projection</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms.update_map", "modulename": "clev2er.tools.plot_waveforms", "qualname": "update_map", "kind": "function", "doc": "<p>Update the map with the track and the current location.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ax (plt.Axes):</strong>  The map axis to update.</li>\n<li><strong>current_lat (float):</strong>  The current latitude of the waveform.</li>\n<li><strong>current_lon (float):</strong>  The current longitude of the waveform.</li>\n<li><strong>latitudes (np.ndarray):</strong>  Array of latitude values for the track.</li>\n<li><strong>longitudes (np.ndarray):</strong>  Array of longitude values for the track.</li>\n<li><strong>extent (list[float] | None, optional):</strong>  The extent for the map projection. Defaults to None.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ax</span><span class=\"p\">:</span> <span class=\"n\">cartopy</span><span class=\"o\">.</span><span class=\"n\">mpl</span><span class=\"o\">.</span><span class=\"n\">geoaxes</span><span class=\"o\">.</span><span class=\"n\">GeoAxes</span>,</span><span class=\"param\">\t<span class=\"n\">current_lat</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">current_lon</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">latitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">longitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">extent</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms.update_plot", "modulename": "clev2er.tools.plot_waveforms", "qualname": "update_plot", "kind": "function", "doc": "<p>Update the waveform and map plots.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>index (int):</strong>  The current index of the waveform.</li>\n<li><strong>ax_waveform (plt.Axes):</strong>  The waveform plot axis.</li>\n<li><strong>ax_map (plt.Axes):</strong>  The map plot axis.</li>\n<li><strong>waveforms (np.ndarray):</strong>  Array of waveform data.</li>\n<li><strong>latitudes (np.ndarray):</strong>  Array of latitude values.</li>\n<li><strong>longitudes (np.ndarray):</strong>  Array of longitude values.</li>\n<li><strong>file_name (str):</strong>  The name of the file being displayed.</li>\n<li><strong>wf_name (str):</strong>  name of the waveform parameter being plotted</li>\n<li><strong>fig (plt.Figure):</strong>  The figure object for the plot.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">ax_waveform</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">ax_map</span><span class=\"p\">:</span> <span class=\"n\">cartopy</span><span class=\"o\">.</span><span class=\"n\">mpl</span><span class=\"o\">.</span><span class=\"n\">geoaxes</span><span class=\"o\">.</span><span class=\"n\">GeoAxes</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">latitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">longitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">wf_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">fig</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">figure</span><span class=\"o\">.</span><span class=\"n\">Figure</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms.get_default_parameter_names", "modulename": "clev2er.tools.plot_waveforms", "qualname": "get_default_parameter_names", "kind": "function", "doc": "<p>Get default parameter names for specific file types if not provided.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_name (str):</strong>  The name of the file being processed.</li>\n<li><strong>waveform_parameter_name (str | None):</strong>  The waveform parameter name.</li>\n<li><strong>latname (str | None):</strong>  The latitude parameter name.</li>\n<li><strong>lonname (str | None):</strong>  The longitude parameter name.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple[str, str, str,str]: The waveform parameter name,\n  latitude name,longitude name.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">waveform_parameter_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">latname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lonname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms.get_scale_factor", "modulename": "clev2er.tools.plot_waveforms", "qualname": "get_scale_factor", "kind": "function", "doc": "<p>retrieve an array of scale factors to convert waveform counts to Watts\nThis is mission dependant</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>nc (Dataset):</strong> netcdf dataset</li>\n<li><strong>file_name (str):</strong>  file name</li>\n<li><strong>wf_name (str):</strong>  name of waveform parameter</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">nc</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">wf_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms.get_variable", "modulename": "clev2er.tools.plot_waveforms", "qualname": "get_variable", "kind": "function", "doc": "<p>Retrieve variable from NetCDF file, handling groups if necessary.</p>\n\n<p>This function navigates through groups in a NetCDF file to retrieve the specified variable.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>nc (Dataset):</strong>  The NetCDF dataset object.</li>\n<li><strong>nc_var_path (str):</strong>  The path to the variable within the NetCDF file,\nwith groups separated by '/'.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Variable: The retrieved NetCDF variable.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SystemExit:</strong>  If the variable or group is not found in the NetCDF file.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">nc</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">nc_var_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Variable</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms.main", "modulename": "clev2er.tools.plot_waveforms", "qualname": "main", "kind": "function", "doc": "<p>Main function to parse arguments and plot waveforms.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>args (list[str]):</strong>  List of command-line arguments passed to the script.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cmd_args</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "kind": "module", "doc": "<p>cpom.altimetry.tools.plot_waveforms.py</p>\n\n<h1 id=\"tool-to-plot-altimetry-waveforms-directly-supports\">Tool to plot altimetry waveforms. Directly supports:</h1>\n\n<p>CRISTAL L1b\nCS2 L1b</p>\n\n<ul>\n<li>any NetCDF file that has selectable latitude, longitude and waveform parameters</li>\n</ul>\n"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.get_scaled_font_size", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "get_scaled_font_size", "kind": "function", "doc": "<p>Calculate a dynamically scaled font size based on the length of the file name.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_name (str):</strong>  The file name to scale the font size for.</li>\n<li><strong>max_len (int, optional):</strong>  The maximum length for scaling. Defaults to 50.</li>\n<li><strong>base_size (int, optional):</strong>  The base font size. Defaults to 16.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>int: The calculated font size.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">max_len</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">base_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">16</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.get_projection_and_extent", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "get_projection_and_extent", "kind": "function", "doc": "<p>Determine the appropriate Cartopy projection and extent based on latitude.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lat (float):</strong>  The latitude to determine the projection for.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple[ccrs.Projection, list[float] | None]: The Cartopy projection and the extent.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lat</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">cartopy</span><span class=\"o\">.</span><span class=\"n\">crs</span><span class=\"o\">.</span><span class=\"n\">Projection</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.update_map", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "update_map", "kind": "function", "doc": "<p>Update the map with the track and the current location.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ax (plt.Axes):</strong>  The map axis to update.</li>\n<li><strong>current_lat (float):</strong>  The current latitude of the waveform.</li>\n<li><strong>current_lon (float):</strong>  The current longitude of the waveform.</li>\n<li><strong>latitudes (np.ndarray):</strong>  Array of latitude values for the track.</li>\n<li><strong>longitudes (np.ndarray):</strong>  Array of longitude values for the track.</li>\n<li><strong>extent (list[float] | None, optional):</strong>  The extent for the map projection. Defaults to None.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ax</span><span class=\"p\">:</span> <span class=\"n\">cartopy</span><span class=\"o\">.</span><span class=\"n\">mpl</span><span class=\"o\">.</span><span class=\"n\">geoaxes</span><span class=\"o\">.</span><span class=\"n\">GeoAxes</span>,</span><span class=\"param\">\t<span class=\"n\">current_lat</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">current_lon</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">latitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">longitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">extent</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.update_plot", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "update_plot", "kind": "function", "doc": "<p>Update the waveform and map plots.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>index (int):</strong>  The current index of the waveform.</li>\n<li><strong>ax_waveform (plt.Axes):</strong>  The waveform plot axis.</li>\n<li><strong>ax_map (plt.Axes):</strong>  The map plot axis.</li>\n<li><strong>waveforms (np.ndarray):</strong>  Array of waveform data.</li>\n<li><strong>latitudes (np.ndarray):</strong>  Array of latitude values.</li>\n<li><strong>longitudes (np.ndarray):</strong>  Array of longitude values.</li>\n<li><strong>file_name (str):</strong>  The name of the file being displayed.</li>\n<li><strong>wf_name (str):</strong>  name of the waveform parameter being plotted</li>\n<li><strong>fig (plt.Figure):</strong>  The figure object for the plot.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">ax_waveform</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">ax_map</span><span class=\"p\">:</span> <span class=\"n\">cartopy</span><span class=\"o\">.</span><span class=\"n\">mpl</span><span class=\"o\">.</span><span class=\"n\">geoaxes</span><span class=\"o\">.</span><span class=\"n\">GeoAxes</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">latitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">longitudes</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">wf_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">fig</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">figure</span><span class=\"o\">.</span><span class=\"n\">Figure</span>,</span><span class=\"param\">\t<span class=\"n\">qc_flags_array</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.get_default_parameter_names", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "get_default_parameter_names", "kind": "function", "doc": "<p>Get default parameter names for specific file types if not provided.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_name (str):</strong>  The name of the file being processed.</li>\n<li><strong>waveform_parameter_name (str | None):</strong>  The waveform parameter name.</li>\n<li><strong>latname (str | None):</strong>  The latitude parameter name.</li>\n<li><strong>lonname (str | None):</strong>  The longitude parameter name.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple[str, str, str,str]: The waveform parameter name,\n  latitude name,longitude name.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">waveform_parameter_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">latname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lonname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.get_scale_factor", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "get_scale_factor", "kind": "function", "doc": "<p>retrieve an array of scale factors to convert waveform counts to Watts\nThis is mission dependant</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>nc (Dataset):</strong> netcdf dataset</li>\n<li><strong>file_name (str):</strong>  file name</li>\n<li><strong>wf_name (str):</strong>  name of waveform parameter</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">nc</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">wf_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.get_variable", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "get_variable", "kind": "function", "doc": "<p>Retrieve variable from NetCDF file, handling groups if necessary.</p>\n\n<p>This function navigates through groups in a NetCDF file to retrieve the specified variable.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>nc (Dataset):</strong>  The NetCDF dataset object.</li>\n<li><strong>nc_var_path (str):</strong>  The path to the variable within the NetCDF file,\nwith groups separated by '/'.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Variable: The retrieved NetCDF variable.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SystemExit:</strong>  If the variable or group is not found in the NetCDF file.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">nc</span><span class=\"p\">:</span> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Dataset</span>,</span><span class=\"param\">\t<span class=\"n\">nc_var_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">netCDF4</span><span class=\"o\">.</span><span class=\"n\">_netCDF4</span><span class=\"o\">.</span><span class=\"n\">Variable</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.plot_waveforms_waveform_qc.main", "modulename": "clev2er.tools.plot_waveforms_waveform_qc", "qualname": "main", "kind": "function", "doc": "<p>Main function to parse arguments and plot waveforms.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>args (list[str]):</strong>  List of command-line arguments passed to the script.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cmd_args</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain", "modulename": "clev2er.tools.run_chain", "kind": "module", "doc": "<p>Main command line run control tool for CLEV2ER algorithm framework chains</p>\n\n<h6 id=\"setup-requires\">Setup requires:</h6>\n\n<blockquote>\n  <p>Set CLEV2ER_BASE_DIR to point to the base directory of the CLEV2ER framework\n      export CLEV2ER_BASE_DIR=/Users/alanmuir/software/clev2er</p>\n  \n  <p>PYTHONPATH to include $CLEV2ER_BASE_DIR/src\n      export PYTHONPATH=$PYTHONPATH:$CLEV2ER_BASE_DIR/src</p>\n</blockquote>\n\n<h6 id=\"example-usage\">Example usage:</h6>\n\n<blockquote>\n  <p>To list all command line options:</p>\n  \n  <p><code>python run_chain.py -h</code></p>\n  \n  <p>b) Run the cryotempo land ice chain on a single L2b file:</p>\n  \n  <p><code>python run_chain.py --name cryotempo -f         $CLEV2ER_BASE_DIR/testdata/cs2/l1bfiles/            CS_OFFL_SIR_LRM_1B_20200930T235609_20200930T235758_D001.nc</code></p>\n  \n  <p>a) Run the cryotempo land ice chain on all l1b files in \n     $CLEV2ER_BASE_DIR/testdata/cs2/l1bfiles</p>\n  \n  <p><code>python run_chain.py --name cryotempo --dir $CLEV2ER_BASE_DIR/testdata/cs2/l1bfiles</code></p>\n  \n  <p>Run with multi-processing and shared memory enabled (also can set these in main config):</p>\n  \n  <p><code>python run_chain.py --name cryotempo -d $CLEV2ER_BASE_DIR/testdata/cs2/l1bfiles -sm -mp</code></p>\n</blockquote>\n"}, {"fullname": "clev2er.tools.run_chain.exception_hook", "modulename": "clev2er.tools.run_chain", "qualname": "exception_hook", "kind": "function", "doc": "<p>log Exception traceback output to the error log, instead of just to the console\nWithout this, these error can get missed when the console is not checked</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">exc_type</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"ne\">BaseException</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">exc_value</span><span class=\"p\">:</span> <span class=\"ne\">BaseException</span>,</span><span class=\"param\">\t<span class=\"n\">exc_traceback</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">traceback</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.custom_key", "modulename": "clev2er.tools.run_chain", "qualname": "custom_key", "kind": "function", "doc": "<p>search function to find N in line containing [fN]</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>line (str):</strong>  string containing [fN], where N is an int which may be large</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>N or 0 if not matched</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">line</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.sort_file_by_number", "modulename": "clev2er.tools.run_chain", "qualname": "sort_file_by_number", "kind": "function", "doc": "<p>sort log file by N , where log lines contain the string [fN]</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>filename (str):</strong>  log file path</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.insert_txtfile1_in_txtfile2_after_line_containing_string", "modulename": "clev2er.tools.run_chain", "qualname": "insert_txtfile1_in_txtfile2_after_line_containing_string", "kind": "function", "doc": "<p>Inserts txtfile1 in txtfile2 after line containing target_string</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file1 (str):</strong>  path of txt file1</li>\n<li><strong>file2 (str):</strong>  path of txt file2</li>\n<li><strong>target_string (str):</strong>  string to search for in file2 and insert contents of file1 after</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file1</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">file2</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">target_string</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.append_file", "modulename": "clev2er.tools.run_chain", "qualname": "append_file", "kind": "function", "doc": "<p>appends contents of file1_path to end of  file2_path</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file1_path (str):</strong>  txt file to append</li>\n<li><strong>file2_path (str):</strong>  txt file to append to end of</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file1_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">file2_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.remove_strings_from_file", "modulename": "clev2er.tools.run_chain", "qualname": "remove_strings_from_file", "kind": "function", "doc": "<p>removes any string [fN] from the txt file</p>\n\n<pre><code>where N is any integer\n</code></pre>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>filename (str):</strong>  file name</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.run_chain_on_single_file", "modulename": "clev2er.tools.run_chain", "qualname": "run_chain_on_single_file", "kind": "function", "doc": "<p>Runs the algorithm chain on a single L1b file.</p>\n\n<p>This function is run in a separate process if multi-processing is enabled.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b_file (str):</strong>  path of L1b file to process</li>\n<li><strong>alg_object_list (list[Algorithm]):</strong>  list of Algorithm objects</li>\n<li><strong>log (logging.Logger):</strong>  logging instance to use</li>\n<li><strong>log_queue (Queue):</strong>  Queue for multi-processing logging</li>\n<li><strong>rval_queue (Queue) :</strong>  Queue for multi-processing results</li>\n<li><strong>filenum (int) :</strong>  file number being processed</li>\n<li><strong>breakpoint_alg_name (str) :</strong>  if not '', name of algorithm to break after.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple(bool,str,str,dict):\n  : algorithms success (True) or Failure (False),\n  : '' or error string\n  : path of breakpoint file or ''\n  : shared_dict\n  for multi-processing return values are instead queued -> rval_queue for this process</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">l1b_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">alg_object_list</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span>,</span><span class=\"param\">\t<span class=\"n\">log_queue</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">bound</span> <span class=\"n\">method</span> <span class=\"n\">BaseContext</span><span class=\"o\">.</span><span class=\"n\">Queue</span> <span class=\"n\">of</span> <span class=\"o\">&lt;</span><span class=\"n\">multiprocessing</span><span class=\"o\">.</span><span class=\"n\">context</span><span class=\"o\">.</span><span class=\"n\">DefaultContext</span> <span class=\"nb\">object</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">rval_queue</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">bound</span> <span class=\"n\">method</span> <span class=\"n\">BaseContext</span><span class=\"o\">.</span><span class=\"n\">Queue</span> <span class=\"n\">of</span> <span class=\"o\">&lt;</span><span class=\"n\">multiprocessing</span><span class=\"o\">.</span><span class=\"n\">context</span><span class=\"o\">.</span><span class=\"n\">DefaultContext</span> <span class=\"nb\">object</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">filenum</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">breakpoint_alg_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.mp_logger_process", "modulename": "clev2er.tools.run_chain", "qualname": "mp_logger_process", "kind": "function", "doc": "<p>executed in a separate process that performs logging\n   used for when multi-processing only</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>queue (Queue):</strong>  object created by multiprocessing.Queue()</li>\n<li><strong>config (dict):</strong>  main config dictionary for log file paths</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">queue</span>, </span><span class=\"param\"><span class=\"n\">config</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.run_chain", "modulename": "clev2er.tools.run_chain", "qualname": "run_chain", "kind": "function", "doc": "<p>Run the algorithm chain in algorithm_list on each L1b file in l1b_file_list\n   using the configuration settings in config</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>l1b_file_list (list[str]):</strong>  list of l1b files paths to process</li>\n<li><strong>config (dict):</strong>  configuration dictionary. This is the named chain config and the\nmain config merged</li>\n<li><strong>algorithm_list (list[str]):</strong>  list of algorithm names</li>\n<li><strong>log (logging.Logger):</strong>  log instance to use</li>\n<li><strong>breakpoint_alg_name (str):</strong>  name of algorithm to set break point after.\nDefault='' (no breakpoint set here)</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple(bool,int,int, int,str,dict) :\n  :chain success or failure,\n  :number_of_errors,\n  :number of files processed,\n  :number of files skipped(for valid reasons),\n  :breakpoint filename\n  :shared_dict (of last file processed in sequential mode only, else {})</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">l1b_file_list</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">algorithm_list</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span>,</span><span class=\"param\">\t<span class=\"n\">breakpoint_alg_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.extract_version", "modulename": "clev2er.tools.run_chain", "qualname": "extract_version", "kind": "function", "doc": "<p>extract the version string from pyproject.toml files</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>toml_file_path (str):</strong>  path of pyproject.toml</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: semantic version string, such as \"0.1.0\"</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">toml_file_path</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.valid_datetime", "modulename": "clev2er.tools.run_chain", "qualname": "valid_datetime", "kind": "function", "doc": "<p>Validate the date string with optional time and timezone.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>date_string (str):</strong>  The date string to validate. Expected formats are\n<code>YYYY-MM-DD</code> or <code>YYYY-MM-DD HH:MM:SS</code>.</li>\n<li><strong>is_end_date (bool):</strong>  If True and the date string is <code>YYYY-MM-DD</code>, return the end of the day.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>datetime: A <code>datetime</code> object parsed from the input string.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>argparse.ArgumentTypeError:</strong>  If the date string does not match the valid formats.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">date_string</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">is_end_date</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.comma_separated_intvals", "modulename": "clev2er.tools.run_chain", "qualname": "comma_separated_intvals", "kind": "function", "doc": "<p>convert comma separated values in a str to a list of int</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  string to process</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>argparse.ArgumentTypeError:</strong>  if wrong types used</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[int]: list of integers</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.filter_files_by_instrument_mode_substrings", "modulename": "clev2er.tools.run_chain", "qualname": "filter_files_by_instrument_mode_substrings", "kind": "function", "doc": "<p>Filters the list of file paths to include only those that match any of the specified substrings.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file_list</strong>:  List of file paths.</li>\n<li><strong>substrings</strong>:  List of substrings to match (e.g., ['SIC', 'SAC']).</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>List of file paths that contain any of the specified substrings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file_list</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">substrings</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.filter_files_by_processing_mode_substrings", "modulename": "clev2er.tools.run_chain", "qualname": "filter_files_by_processing_mode_substrings", "kind": "function", "doc": "<p>Filters the list of file paths to include only those that match any of the specified substrings.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file_list</strong>:  List of file paths.</li>\n<li><strong>substrings</strong>:  List of substrings to match (e.g., ['HR', 'FF']).</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>List of file paths that contain any of the specified substrings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file_list</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">substrings</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.set_nested_key", "modulename": "clev2er.tools.run_chain", "qualname": "set_nested_key", "kind": "function", "doc": "<p>Set a value in a nested dictionary.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config (Dict[str, Any]):</strong>  The dictionary to update.</li>\n<li><strong>keys (List[str]):</strong>  A list of keys representing the path to the nested value.</li>\n<li><strong>value (Any):</strong>  The value to set at the specified nested location.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>None</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">keys</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.run_chain.main", "modulename": "clev2er.tools.run_chain", "qualname": "main", "kind": "function", "doc": "<p>main function</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.tests", "modulename": "clev2er.tools.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.tools.tests.conftest", "modulename": "clev2er.tools.tests.conftest", "kind": "module", "doc": "<p>This module configures pytest to set the multiprocessing start method to 'spawn' before\nany tests are run.\nThis ensures consistency in the multiprocessing behavior across different environments and prevents\nRuntimeError caused by setting the context multiple times.</p>\n"}, {"fullname": "clev2er.tools.tests.conftest.pytest_configure", "modulename": "clev2er.tools.tests.conftest", "qualname": "pytest_configure", "kind": "function", "doc": "<p>Configure pytest before any tests are run. This function sets the\nmultiprocessing start method to 'spawn' if it hasn't been set already.\nThis is necessary to avoid RuntimeError in environments where the start\nmethod might be set implicitly or by other parts of the test suite.</p>\n\n<p>Parameters:\nconfig (pytest.Config): The pytest config object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">config</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.tools.tests.test_run_chain", "modulename": "clev2er.tools.tests.test_run_chain", "kind": "module", "doc": "<p>pytest functions to test\nsrc/clev2er/tools/run_chain.py: runc_chain()</p>\n"}, {"fullname": "clev2er.tools.tests.test_run_chain.test_run_chain", "modulename": "clev2er.tools.tests.test_run_chain", "qualname": "test_run_chain", "kind": "function", "doc": "<p>pytest functions to test src/clev2er/tools/run_chain.py: run_chain()</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">mp_enabled</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils", "modulename": "clev2er.utils", "kind": "module", "doc": "<p><strong>Utility Modules</strong></p>\n"}, {"fullname": "clev2er.utils.areas", "modulename": "clev2er.utils.areas", "kind": "module", "doc": "<h1 id=\"area-definitions-and-map-plotting\">Area Definitions and Map Plotting</h1>\n\n<p>Contains utility classes to handle plotting of predefined polar (or other) areas</p>\n\n<h2 id=\"area-definitions\">Area Definitions</h2>\n\n<p>Area definitions define</p>\n\n<ul>\n<li>Area projection</li>\n<li>Area extent</li>\n<li>Data mask applied when plotting data over the area</li>\n<li>Plot background</li>\n</ul>\n\n<h6 id=\"area-definitions-are-each-stored-in-a-python-dictionary-within-a-separate-file\">Area definitions are each stored in a python dictionary within a separate file:</h6>\n\n<blockquote>\n  <p>$CLEV2ER_BASE_DIR/src/clev2er/utils/areas/definitions/<strong>area_name.py</strong></p>\n</blockquote>\n\n<p>The area naming convention used is as follows:</p>\n\n<p><strong>area</strong>&#95;<em>background</em>&#95;<em>datamask</em>.py  where <em>background</em> and <em>datamask</em> are optional.</p>\n\n<table>\n<thead>\n<tr>\n  <th>area_name</th>\n  <th>Background</th>\n  <th>Mask</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>antarctica</td>\n  <td>basic_land</td>\n  <td>None</td>\n</tr>\n<tr>\n  <td>antarctica_is</td>\n  <td>basic_land</td>\n  <td>antarctica_bedmachine_v2_grid_mask[2,4] == grounded ice sheet</td>\n</tr>\n<tr>\n  <td>antarctica_fi</td>\n  <td>basic_land</td>\n  <td>floating ice only : bedmachine mask</td>\n</tr>\n<tr>\n  <td>antarctica_hs_is</td>\n  <td>hillshade</td>\n  <td>antarctica_bedmachine_v2_grid_mask[2,4] == grounded ice sheet</td>\n</tr>\n<tr>\n  <td>antarctica_hs_fi</td>\n  <td>hillshade</td>\n  <td>floating ice only : bedmachine mask</td>\n</tr>\n<tr>\n  <td>greenland</td>\n  <td>basic_land</td>\n  <td>None</td>\n</tr>\n<tr>\n  <td>greenland_is</td>\n  <td>basic_land</td>\n  <td>antarctica_bedmachine_v2_grid_mask[2,4] == grounded ice sheet</td>\n</tr>\n<tr>\n  <td>greenland_fi</td>\n  <td>basic_land</td>\n  <td>floating ice only : bedmachine mask</td>\n</tr>\n<tr>\n  <td>greenland_hs_is</td>\n  <td>hillshade</td>\n  <td>antarctica_bedmachine_v2_grid_mask[2,4] == grounded ice sheet</td>\n</tr>\n<tr>\n  <td>greenland_hs_fi</td>\n  <td>hillshade</td>\n  <td>floating ice only : bedmachine mask</td>\n</tr>\n</tbody>\n</table>\n"}, {"fullname": "clev2er.utils.areas.areas", "modulename": "clev2er.utils.areas.areas", "kind": "module", "doc": "<p>clev2er.utils.areas.areas.py: Area class to define areas for polar plotting</p>\n"}, {"fullname": "clev2er.utils.areas.areas.list_all_area_definition_names", "modulename": "clev2er.utils.areas.areas", "qualname": "list_all_area_definition_names", "kind": "function", "doc": "<p>return a list of all area definition names</p>\n\n<p>Raises:</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[str]: _description_</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">logger</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.areas.Area", "modulename": "clev2er.utils.areas.areas", "qualname": "Area", "kind": "class", "doc": "<p>class to define polar areas for plotting etc</p>\n"}, {"fullname": "clev2er.utils.areas.areas.Area.__init__", "modulename": "clev2er.utils.areas.areas", "qualname": "Area.__init__", "kind": "function", "doc": "<p>class initialization</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  area name. Must be in all_areas</li>\n<li><strong>overrides (dict|None):</strong>  dictionary to override any parameters in area definition dicts</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">overrides</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "clev2er.utils.areas.areas.Area.load_area", "modulename": "clev2er.utils.areas.areas", "qualname": "Area.load_area", "kind": "function", "doc": "<p>Load area settings for current area name</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">overrides</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.areas.Area.latlon_to_xy", "modulename": "clev2er.utils.areas.areas", "qualname": "Area.latlon_to_xy", "kind": "function", "doc": "<p>convert latitude and longitude to x,y in area's projection</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lats (np.ndarray|float|list):</strong>  latitude values</li>\n<li><strong>lons (np.ndarray|float|list):</strong>  longitude values</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(np.ndarray,np.ndarray): x,y</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lats</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span> <span class=\"o\">|</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">lons</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span> <span class=\"o\">|</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">list</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.areas.Area.xy_to_latlon", "modulename": "clev2er.utils.areas.areas", "qualname": "Area.xy_to_latlon", "kind": "function", "doc": "<p>convert from x,y to latitide, longitiude in area's projection</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>x (np.ndarray):</strong>  x coordinates</li>\n<li><strong>y (np.ndarray):</strong>  y coordinates</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(np.ndarray,np.ndarray): latitude values, longitude values</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span> <span class=\"o\">|</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span> <span class=\"o\">|</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">list</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.areas.Area.inside_xy_extent", "modulename": "clev2er.utils.areas.areas", "qualname": "Area.inside_xy_extent", "kind": "function", "doc": "<p>filter points based on x,y extent of area</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lats (np.ndarray):</strong>  latitude values (degs N)</li>\n<li><strong>lons (np.ndarray):</strong>  longitude values (deg E)</li>\n<li><strong>inputs_are_xy (bool):</strong>  if True treat inputs as cartesian: x=lats, y=lons</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(lats_inside, lons_inside, x_inside, y_inside, indices_inside, n_inside):\n  lats_inside (np.ndarray): lat values inside area\n  lons_inside (np.ndarray): lon values inside area\n  x_inside (np.ndarray): projected x coords inside area\n  y_inside (np.ndarray): projected y coords inside area\n  indices_inside (np.ndarray): indices of original lats,lons that are inside\n  n_inside (int): number of original lats, lons that were inside</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lats</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">lons</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">inputs_are_xy</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.areas.Area.inside_latlon_bounds", "modulename": "clev2er.utils.areas.areas", "qualname": "Area.inside_latlon_bounds", "kind": "function", "doc": "<p>find if input latitude and longitude locations are inside area's lat/lon extent\n   bounds</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lats (np.ndarray):</strong>  array of latitude values (degs N)</li>\n<li><strong>lons (np.ndarray):</strong>  array of longitude values (degs E)</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(bounded_lats|None, bounded_lons|None, bounded_indices|None, bounded_indices.size):</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lats</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">lons</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.areas.Area.inside_mask", "modulename": "clev2er.utils.areas.areas", "qualname": "Area.inside_mask", "kind": "function", "doc": "<p>Find indices of x,y coords inside the area's data mask (if there is one).</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>x (np.ndarray):</strong>  x coordinates in areas's projection</li>\n<li><strong>y (np.ndarray):</strong>  y coordinates in areas's projection</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>indices_in_maskarea (np.ndarray) : indices inside mask or empty np.ndarray\n  n_inside (int) : number of points inside mask</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>, </span><span class=\"param\"><span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.definitions", "modulename": "clev2er.utils.areas.definitions", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.antarctica", "modulename": "clev2er.utils.areas.definitions.antarctica", "kind": "module", "doc": "<p>Area definition</p>\n"}, {"fullname": "clev2er.utils.areas.definitions.antarctica_basic", "modulename": "clev2er.utils.areas.definitions.antarctica_basic", "kind": "module", "doc": "<p>Area definition</p>\n"}, {"fullname": "clev2er.utils.areas.definitions.antarctica_fi", "modulename": "clev2er.utils.areas.definitions.antarctica_fi", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: antarctica\n<strong>Data mask: floating ice from bedmachine v2</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.antarctica_hs", "modulename": "clev2er.utils.areas.definitions.antarctica_hs", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: antarctica\n<strong>background_image: hillshade</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.antarctica_hs_fi", "modulename": "clev2er.utils.areas.definitions.antarctica_hs_fi", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: antarctica\n<strong>background_image: hillshade</strong>\n<strong>Data mask: floating ice from bedmachine v2</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.antarctica_hs_is", "modulename": "clev2er.utils.areas.definitions.antarctica_hs_is", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: antarctica\n<strong>background_image: hillshade</strong>\n<strong>Data mask: grounded ice from bedmachine v2</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.antarctica_is", "modulename": "clev2er.utils.areas.definitions.antarctica_is", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: antarctica\n<strong>Data mask: grounded ice from bedmachine v2</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.arctic", "modulename": "clev2er.utils.areas.definitions.arctic", "kind": "module", "doc": "<p>Area definition</p>\n"}, {"fullname": "clev2er.utils.areas.definitions.arctic_cpy", "modulename": "clev2er.utils.areas.definitions.arctic_cpy", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: arctic\n<strong>Data mask: floating ice from bedmachine v3</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.global", "modulename": "clev2er.utils.areas.definitions.global", "kind": "module", "doc": "<p>Area definition</p>\n"}, {"fullname": "clev2er.utils.areas.definitions.greenland", "modulename": "clev2er.utils.areas.definitions.greenland", "kind": "module", "doc": "<p>Area definition</p>\n"}, {"fullname": "clev2er.utils.areas.definitions.greenland_fi", "modulename": "clev2er.utils.areas.definitions.greenland_fi", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: greenland\n<strong>Data mask: floating ice from bedmachine v3</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.greenland_hs", "modulename": "clev2er.utils.areas.definitions.greenland_hs", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: greenland\n<strong>background_image: hillshade</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.greenland_hs_fi", "modulename": "clev2er.utils.areas.definitions.greenland_hs_fi", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: greenland\n<em>*mask: greenland_bedmachine_v3_grid_mask[3] == floating ice *</em></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.greenland_hs_is", "modulename": "clev2er.utils.areas.definitions.greenland_hs_is", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: greenland\n<strong>mask: greenland_bedmachine_v3_grid_mask[2] == grounded ice sheet</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.greenland_is", "modulename": "clev2er.utils.areas.definitions.greenland_is", "kind": "module", "doc": "<h1 id=\"area-definition\">Area definition</h1>\n\n<h2 id=\"summary\">Summary:</h2>\n\n<p>Based on area: greenland\n<strong>Data mask: grounded ice from bedmachine v3</strong></p>\n"}, {"fullname": "clev2er.utils.areas.definitions.spirit", "modulename": "clev2er.utils.areas.definitions.spirit", "kind": "module", "doc": "<p>Area definition</p>\n"}, {"fullname": "clev2er.utils.areas.definitions.vostok", "modulename": "clev2er.utils.areas.definitions.vostok", "kind": "module", "doc": "<p>Area definition</p>\n"}, {"fullname": "clev2er.utils.areas.tests", "modulename": "clev2er.utils.areas.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.areas.tests.test_areas", "modulename": "clev2er.utils.areas.tests.test_areas", "kind": "module", "doc": "<p>pytests for clev2er.utils.areas.areas.py</p>\n"}, {"fullname": "clev2er.utils.areas.tests.test_areas.test_bad_area_name", "modulename": "clev2er.utils.areas.tests.test_areas", "qualname": "test_bad_area_name", "kind": "function", "doc": "<p>pytest to check for handling of invalid area names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.tests.test_areas.test_good_area_name", "modulename": "clev2er.utils.areas.tests.test_areas", "qualname": "test_good_area_name", "kind": "function", "doc": "<p>pytest to check for handling of valid area names</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.areas.tests.test_plots", "modulename": "clev2er.utils.areas.tests.test_plots", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.breakpoints", "modulename": "clev2er.utils.breakpoints", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.breakpoints.breakpoint_files", "modulename": "clev2er.utils.breakpoints.breakpoint_files", "kind": "module", "doc": "<p>clev2er.utils.breakpoints.breakpoint_files.py</p>\n\n<p>Functions to support writing of breakpoint files</p>\n"}, {"fullname": "clev2er.utils.breakpoints.breakpoint_files.create_netcdf_file", "modulename": "clev2er.utils.breakpoints.breakpoint_files", "qualname": "create_netcdf_file", "kind": "function", "doc": "<p>Create a NetCDF4 file from contents of a dictionary</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_path (str):</strong>  _description_</li>\n<li><strong>data_dict (dict):</strong>  dictionary containing 1 or more levels</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>None</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file_path</span>, </span><span class=\"param\"><span class=\"n\">data_dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.breakpoints.breakpoint_files.write_breakpoint_file", "modulename": "clev2er.utils.breakpoints.breakpoint_files", "qualname": "write_breakpoint_file", "kind": "function", "doc": "<p>write a netcdf breakpoint file containing contents of\n   shared dictionary</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config (dict):</strong>  chain config file</li>\n<li><strong>shared_dict (dict):</strong>  shared working dictionary</li>\n<li><strong>log (logging.Logger):</strong>  current logger instance to use</li>\n<li><strong>breakpoint_alg_name (str):</strong>  name of the algorithm after which the bp is set</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(str) : path of breakpoint file</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">shared_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span>,</span><span class=\"param\">\t<span class=\"n\">breakpoint_alg_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.breakpoints.tests", "modulename": "clev2er.utils.breakpoints.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.breakpoints.tests.test_breakpoint_files", "modulename": "clev2er.utils.breakpoints.tests.test_breakpoint_files", "kind": "module", "doc": "<p>pytest tests of clev2er.utils.breakpoints</p>\n"}, {"fullname": "clev2er.utils.breakpoints.tests.test_breakpoint_files.test_breakpoint_files", "modulename": "clev2er.utils.breakpoints.tests.test_breakpoint_files", "qualname": "test_breakpoint_files", "kind": "function", "doc": "<p>pytest function for write_breakpoint_file()</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tmp_path</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.config", "modulename": "clev2er.utils.config", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.config.load_config_settings", "modulename": "clev2er.utils.config.load_config_settings", "kind": "module", "doc": "<p>utils.config.load_config_settings.py</p>\n\n<p>Common functions to load chain configuration files</p>\n\n<p>load_algorithm_list(chain_name: str, baseline: str = \"\", version=0) -> list[str],list[str]\nload_config_files(chain_name: str, baseline: str = \"\") -> dict:</p>\n"}, {"fullname": "clev2er.utils.config.load_config_settings.load_algorithm_list", "modulename": "clev2er.utils.config.load_config_settings", "qualname": "load_algorithm_list", "kind": "function", "doc": "<p>load algorithm and L1b finder list for specified chain</p>\n\n<p>Lists of algorithms and finder modules are either stored in XML or YML formats</p>\n\n<p>$CLEV2ER_BASE_DIR/config/algorithm_lists/<chain_name>/*.[xml,.yml]</p>\n\n<p>Search rules:</p>\n\n<p>Either an xml or a yml file (but not both) must exist in\n$CLEV2ER_BASE_DIR/config/algorithm_lists/<chain_name>/*.[xml,.yml]</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>chain_name (str):</strong>  name of the chain to load</li>\n<li><strong>alg_list_file (str,optional):</strong>  path of algorithm list file to use. default=\"\" which means\nsearch for one in standard locations</li>\n<li><strong>log (logging.Logger, optional):</strong>  log instance to use, default is None (use module loggger)</li>\n</ul>\n\n<p>Raises: KeyError,ValueError,OSError,NameError</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[str], list[str], str,str:\n      list of algorithm names,\n      list of finder module names - may be empty list,\n      filename of algorithm list used\n      name of algorithm to set breakpoint after or '' if no breakpoint set</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">chain_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">alg_list_file</span><span class=\"o\">=</span><span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.config.load_config_settings.load_config_files", "modulename": "clev2er.utils.config.load_config_settings", "qualname": "load_config_files", "kind": "function", "doc": "<p>function to load XML,or YML configuration files for a chain and return\n   as a python dict</p>\n\n<p>Configuration files consist of:</p>\n\n<p>$CLEV2ER_BASE_DIR/config/main_config.xml</p>\n\n<p>+</p>\n\n<p>$CLEV2ER_BASE_DIR/config/chain_configs/{chain_name}/<a_config_file>.yml, .xml</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>chain_name (_type_, optional):</strong>  _description_. Defaults to \"\",</li>\n<li><strong>main_config_file (str, optional):</strong>  _description_. Defaults to \"\".</li>\n<li><strong>chain_config_file (str, optional):</strong>  _description_. Defaults to \"\".</li>\n</ul>\n\n<p>Raises: KeyError, OSError, ValueError</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>(dict,str,str) : config, main_config_file, chain_config_file</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">chain_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">main_config_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">chain_config_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.config.tests", "modulename": "clev2er.utils.config.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.config.tests.test_load_algorithm_list", "modulename": "clev2er.utils.config.tests.test_load_algorithm_list", "kind": "module", "doc": "<p>pytest of utils.config.load_config_files()</p>\n"}, {"fullname": "clev2er.utils.config.tests.test_load_algorithm_list.test_load_algorithm_list", "modulename": "clev2er.utils.config.tests.test_load_algorithm_list", "qualname": "test_load_algorithm_list", "kind": "function", "doc": "<p>pytest function for utils.config.load_algorithm_list()</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.config.tests.test_load_config_settings", "modulename": "clev2er.utils.config.tests.test_load_config_settings", "kind": "module", "doc": "<p>pytest of utils.config.load_config_files()</p>\n"}, {"fullname": "clev2er.utils.config.tests.test_load_config_settings.test_load_config_files", "modulename": "clev2er.utils.config.tests.test_load_config_settings", "qualname": "test_load_config_files", "kind": "function", "doc": "<p>pytest function for utils.config.load_config_files()</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal", "modulename": "clev2er.utils.cristal", "kind": "module", "doc": "<h1 id=\"utility-functions-for-clev2er-lig-poca-shared-dict\">Utility functions for CLEV2ER LIG POCA shared dict</h1>\n"}, {"fullname": "clev2er.utils.cristal.clev2er_lig_shared_dict_funcs", "modulename": "clev2er.utils.cristal.clev2er_lig_shared_dict_funcs", "kind": "module", "doc": "<p>Helper functions for updating CLEV2ER LIG shared_dict for CRISTAL</p>\n"}, {"fullname": "clev2er.utils.cristal.clev2er_lig_shared_dict_funcs.update_shared_dict_validity_mask", "modulename": "clev2er.utils.cristal.clev2er_lig_shared_dict_funcs", "qualname": "update_shared_dict_validity_mask", "kind": "function", "doc": "<p>set ku,ka/valid/bool_mask_to_orig to False where input mask is False\nAlso then updates ku,ka/valid/index_to_orig, and ku,ka/valid/num_valid</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>shared_dict (dict):</strong>  chain shared dictionary</li>\n<li><strong>band (str):</strong>  band which is either 'ku' or 'ka'</li>\n<li><strong>mask (np.ndarray[bool]):</strong>  array of boolean to indicate validity of the\nmeasurements</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">shared_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">band</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">mask</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">dtype</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">bool_</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.echo_to_bsa", "modulename": "clev2er.utils.cristal.echo_to_bsa", "kind": "module", "doc": "<p>Echo to Boresight Angle Functions</p>\n"}, {"fullname": "clev2er.utils.cristal.echo_to_bsa.echo_to_bsa", "modulename": "clev2er.utils.cristal.echo_to_bsa.echo_to_bsa", "kind": "module", "doc": "<p>clev2er.utils.cristal.echo_to_bsa.echo_to_bsa.py\nclass to calculate echo to boresight angle</p>\n"}, {"fullname": "clev2er.utils.cristal.echo_to_bsa.echo_to_bsa.calculate_echo_to_boresight_angle", "modulename": "clev2er.utils.cristal.echo_to_bsa.echo_to_bsa", "qualname": "calculate_echo_to_boresight_angle", "kind": "function", "doc": "<p>Calculate the echo to boresight angle based on input parameters.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>phase_waveform (callable):</strong>  A function that returns the phase waveform (\u03a6) at a given</li>\n<li>point.</li>\n<li><strong>sample_bin (int):</strong>  The bin location to sample the phase waveform at.</li>\n<li><strong>wavelength (float):</strong>  The radar wavelength (\u03bb) in meters.</li>\n<li><strong>ant_baseline (float):</strong>  The antenna baseline (b) in meters.</li>\n<li><strong>float:</strong>  The echo to boresight angle in radians.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">phase_waveform</span>, </span><span class=\"param\"><span class=\"n\">sample_bin</span>, </span><span class=\"param\"><span class=\"n\">wavelength</span>, </span><span class=\"param\"><span class=\"n\">ant_baseline</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.echo_to_bsa.tests", "modulename": "clev2er.utils.cristal.echo_to_bsa.tests", "kind": "module", "doc": "<p>echo to bsa function tests</p>\n"}, {"fullname": "clev2er.utils.cristal.echo_to_bsa.tests.test_echo_to_bsa", "modulename": "clev2er.utils.cristal.echo_to_bsa.tests.test_echo_to_bsa", "kind": "module", "doc": "<p>pytest of clev2er.utils.cristal.echo_to_bsa.echo_to_bsa.py</p>\n\n<p>This module contains pytest test cases for validating the functionality of \necho_to_bsa.py, which calculates the echo to boresight angle based on \nphase waveform data, sample bin, wavelength, and antenna baseline.</p>\n\n<p>The tests cover various aspects of the algorithm, including valid input handling, \nedge cases, and exceptions for invalid inputs, ensuring robustness and accuracy in \ncalculating the ehco to boresight angle.</p>\n\n<h2 id=\"summary-of-test-function\"># Summary of Test Function</h2>\n\n<h1 id=\"calculate_echo_to_boresight_angle\">calculate_echo_to_boresight_angle:</h1>\n\n<p>Calculates the echo to boresight angle based on the given parameters.</p>\n\n<p>Test Functions:</p>\n\n<ul>\n<li><p>test_calculate_echo_to_bsa_valid:\nTests the <code>calculate_echo_to_boresight_angle</code> function with valid inputs, including edge cases \nlike sample bin at the first and last index of the waveform. It ensures that the \necho to boresight angle is calculated correctly for various input conditions.</p></li>\n<li><p>test_calculate_echo_to_bsa_invalid:\nEnsures the <code>calculate_echo_to_boresight_angle</code> function raises appropriate exceptions \nfor invalid inputs such as out-of-range sample bins, negative wavelengths, zero or \nnegative antenna baselines, and invalid types for any of the parameters.</p></li>\n</ul>\n"}, {"fullname": "clev2er.utils.cristal.echo_to_bsa.tests.test_echo_to_bsa.test_calculate_echo_to_bsa_valid", "modulename": "clev2er.utils.cristal.echo_to_bsa.tests.test_echo_to_bsa", "qualname": "test_calculate_echo_to_bsa_valid", "kind": "function", "doc": "<p>Test the calculate_echo_to_boresight_angle function with valid and edge case inputs.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">phase_waveform</span>,</span><span class=\"param\">\t<span class=\"n\">sample_bin</span>,</span><span class=\"param\">\t<span class=\"n\">wavelength</span>,</span><span class=\"param\">\t<span class=\"n\">ant_baseline</span>,</span><span class=\"param\">\t<span class=\"n\">expected_echo_to_bsa</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.echo_to_bsa.tests.test_echo_to_bsa.test_calculate_echo_to_bsa_invalid", "modulename": "clev2er.utils.cristal.echo_to_bsa.tests.test_echo_to_bsa", "qualname": "test_calculate_echo_to_bsa_invalid", "kind": "function", "doc": "<p>Test the calculate_echo_to_boresight function with invalid inputs.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">phase_waveform</span>,</span><span class=\"param\">\t<span class=\"n\">sample_bin</span>,</span><span class=\"param\">\t<span class=\"n\">wavelength</span>,</span><span class=\"param\">\t<span class=\"n\">ant_baseline</span>,</span><span class=\"param\">\t<span class=\"n\">expected_exception</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin", "modulename": "clev2er.utils.cristal.reloc_sarin", "kind": "module", "doc": "<p>Sarin Reloc Functions</p>\n"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "modulename": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "kind": "module", "doc": "<p>clev2er.utils.cristal.reloc_sarin.reloc_sarin.py\nclass containing functions to calculate the location and elevation based upon the range\nand angle of arrival.</p>\n"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.reloc_sarin.geodetic_to_ecef", "modulename": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "qualname": "geodetic_to_ecef", "kind": "function", "doc": "<p>Converts geodetic coordinates (latitude, longitude, altitude) to ECEF\n(Earth-Centered Earth-Fixed) coordinates.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lat (array-like):</strong>  Latitudes in degrees, shape (n,).</li>\n<li><strong>lon (array-like):</strong>  Longitudes in degrees, shape (n,).</li>\n<li><strong>alt (array-like):</strong>  Altitudes in meters, shape (n,).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple:\n      np.ndarray: X-coordinates in ECEF, shape (n,).\n      np.ndarray: Y-coordinates in ECEF, shape (n,).\n      np.ndarray: Z-coordinates in ECEF, shape (n,).</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">alt</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.reloc_sarin.ecef_to_geodetic", "modulename": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "qualname": "ecef_to_geodetic", "kind": "function", "doc": "<p>djb to document</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>np.ndarray:</strong>  X-coordinates in ECEF, shape (n,).</li>\n<li><strong>np.ndarray:</strong>  Y-coordinates in ECEF, shape (n,).</li>\n<li><strong>np.ndarray:</strong>  Z-coordinates in ECEF, shape (n,).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple:\n      lat (array-like): Latitudes in degrees, shape (n,).\n      lon (array-like): Longitudes in degrees, shape (n,).\n      alt (array-like): Altitudes in meters, shape (n,).</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">z</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.reloc_sarin.calculate_crf_points", "modulename": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "qualname": "calculate_crf_points", "kind": "function", "doc": "<p>Calculate the CRF (Coordinate Reference Frame) points by solving the intersection of\na circle and a plane.</p>\n\n<p>This method computes the X and Z coordinates for the CRF points based on the filtered\nbaseline vector (<code>base_vector_filt</code>), the echo to boresight angle (<code>echo_to_bsa_filt</code>),\nand the radial distance (<code>r_filt</code>). It solves the corresponding circle and plane\nintersection equations and selects the appropriate solution based on the larger\nX-coordinate.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>base_vector_filt (numpy.ndarray):</strong>  The baseline vector used in the calculation,\nshape (n, 3). Each row represents a 3D vector\n(x, y, z).</li>\n<li><strong>echo_to_bsa_filt (numpy.ndarray):</strong>  The echo to boresight angle, shape (n,).\nEach element contains the angle in radians.</li>\n<li><strong>r_filt (numpy.ndarray):</strong>  The radial distance from the origin, shape (n,).\nA 1D array containing the radial distances for each point.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>numpy.ndarray: The calculated CRF points, shape (n, 3). Each row represents a CRF point\n                  with X, Y, and Z coordinates.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">base_vector_filt</span>, </span><span class=\"param\"><span class=\"n\">echo_to_bsa_filt</span>, </span><span class=\"param\"><span class=\"n\">r_filt</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.reloc_sarin.compute_poca_geodetic_coords", "modulename": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "qualname": "compute_poca_geodetic_coords", "kind": "function", "doc": "<p>Compute the geodetic coordinates (latitude, longitude, elevation) of POCA points\nfor multiple waveforms.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>crf_axes (np.ndarray):</strong>  Array of shape (n, 3, 3), where each 3x3 matrix represents a</li>\n<li>CRF axis for a waveform.</li>\n<li><strong>crf_points (np.ndarray):</strong>  Array of shape (n, 3), where each row represents a point in</li>\n<li>the CRF.</li>\n<li><strong>efc_cogs (np.ndarray):</strong>  Array of shape (n, 3), where each row represents the ECF center</li>\n<li>of gravity.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple: Three arrays for latitude, longitude, and elevation of POCA points,\n  each of shape (n,).</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">crf_axes</span>, </span><span class=\"param\"><span class=\"n\">crf_points</span>, </span><span class=\"param\"><span class=\"n\">efc_cogs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.reloc_sarin.get_crf_in_efc", "modulename": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "qualname": "get_crf_in_efc", "kind": "function", "doc": "<p>Calculate the Satellite Coordinate Frame (CRF) axes in the Earth-Centered Fixed (ECF) frame\nfor multiple waveforms.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lon (np.ndarray):</strong>  Longitudes of the waveforms, shape (n,).</li>\n<li><strong>lat (np.ndarray):</strong>  Latitudes of the waveforms, shape (n,).</li>\n<li><strong>alt (np.ndarray):</strong>  Altitudes of the waveforms, shape (n,).</li>\n<li><strong>vel_vec (np.ndarray):</strong>  Velocity vectors in ECF coordinates, shape (n, 3).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple:\n      np.ndarray: CRF axes matrices, shape (n, 3, 3).\n      np.ndarray: Satellite positions in ECF coordinates, shape (n, 3).</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">alt</span>, </span><span class=\"param\"><span class=\"n\">vel_vec</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.reloc_sarin.reloc_sarin", "modulename": "clev2er.utils.cristal.reloc_sarin.reloc_sarin", "qualname": "reloc_sarin", "kind": "function", "doc": "<p>This function processes the CRF points, satellite CRF orientation, and computes\nthe Poca geodetic coordinates.</p>\n\n<p>Parameters:\nbase_vector_filt (array): Filtered base vector\necho_to_bsa_filt (array): Filtered echo to BSA vector\nr_filt (array): Filtered range vector\nlon_filt (array): Filtered longitude\nlat_filt (array): Filtered latitude\nalt_filt (array): Filtered altitude\nvelocity_vector_filt (array): Filtered velocity vector</p>\n\n<p>Returns:\nlat_poca, lon_poca, elev_poca (tuple): Geodetic coordinates of Poca</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">base_vector_filt</span>,</span><span class=\"param\">\t<span class=\"n\">echo_to_bsa_filt</span>,</span><span class=\"param\">\t<span class=\"n\">r_filt</span>,</span><span class=\"param\">\t<span class=\"n\">lon_filt</span>,</span><span class=\"param\">\t<span class=\"n\">lat_filt</span>,</span><span class=\"param\">\t<span class=\"n\">alt_filt</span>,</span><span class=\"param\">\t<span class=\"n\">velocity_vector_filt</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests", "modulename": "clev2er.utils.cristal.reloc_sarin.tests", "kind": "module", "doc": "<p>Sarin Reloc Tests</p>\n"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "modulename": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "kind": "module", "doc": "<h1 id=\"pytest-of-clev2erutilscristalreloc_sarinreloc_sarinpy\">pytest of clev2er.utils.cristal.reloc_sarin.reloc_sarin.py</h1>\n\n<p>This module contains pytest test cases for validating the functionality of reloc_sarin.py functions.</p>\n\n<h2 id=\"summary-of-test-functions\"># Summary of Test Functions</h2>\n\n<h1 id=\"calculate_crf_points\">calculate_crf_points</h1>\n\n<p>Calculates the CRF points based on input parameters such as base vector, echo-to-boresight angle,<br />\nand radius.</p>\n\n<p>Test Functions:</p>\n\n<ul>\n<li><p>test_calculate_crf_points_valid:<br />\nTests the calculate_crf_points function with valid inputs, verifying that the CRF points are<br />\ncalculated correctly for a range of base vectors and radius values.</p></li>\n<li><p>test_calculate_crf_points_invalid:<br />\nEnsures the calculate_crf_points function raises appropriate exceptions for invalid inputs,<br />\nincluding out-of-range values, incorrect vector formats, or missing parameters.</p></li>\n</ul>\n\n<hr />\n\n<h1 id=\"compute_poca_geodetic_coords\">compute_poca_geodetic_coords</h1>\n\n<p>Converts CRF points to geodetic coordinates.</p>\n\n<p>Test Functions:</p>\n\n<ul>\n<li><p>test_compute_poca_geodetic_coords_valid:<br />\nVerifies the correct transformation of CRF points to geodetic coordinates, ensuring that the<br />\nconversion respects the proper coordinate system and transformations.</p></li>\n<li><p>test_compute_poca_geodetic_coords_invalid:<br />\nEnsures the compute_poca_geodetic_coords function raises appropriate exceptions for invalid or<br />\nincorrectly formatted CRF points, such as missing data or incompatible units.</p></li>\n</ul>\n\n<hr />\n\n<h1 id=\"get_crf_in_efc\">get_crf_in_efc</h1>\n\n<p>Calculates Satellite CRF Orientation in the ECF Frame.</p>\n\n<p>Test Functions:</p>\n\n<ul>\n<li><p>test_get_crf_in_efc_valid:<br />\nValidates the transformation from geodetic coordinates and velocity vectors to CRF axes and the<br />\nEFC center of gravity, checking for correct alignment and expected output.</p></li>\n<li><p>test_get_crf_in_efc_invalid:<br />\nEnsures the get_crf_in_efc function raises appropriate exceptions for invalid geodetic \ncoordinate inputs, incorrect velocity vectors, or missing transformation parameters.</p></li>\n</ul>\n"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin.test_calculate_crf_points_valid", "modulename": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "qualname": "test_calculate_crf_points_valid", "kind": "function", "doc": "<p>Test the calculate_crf_points function with valid and edge case inputs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">base_vector_filt</span>, </span><span class=\"param\"><span class=\"n\">echo_to_bsa_filt</span>, </span><span class=\"param\"><span class=\"n\">r_filt</span>, </span><span class=\"param\"><span class=\"n\">expected_crf_points</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin.test_calculate_crf_points_invalid", "modulename": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "qualname": "test_calculate_crf_points_invalid", "kind": "function", "doc": "<p>Test the calculate_crf_points function with invalid inputs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">base_vector_filt</span>, </span><span class=\"param\"><span class=\"n\">echo_to_bsa_filt</span>, </span><span class=\"param\"><span class=\"n\">r_filt</span>, </span><span class=\"param\"><span class=\"n\">expected_error</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin.test_compute_poca_geodetic_coords_valid", "modulename": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "qualname": "test_compute_poca_geodetic_coords_valid", "kind": "function", "doc": "<p>Test compute_poca_geodetic_coords with valid inputs.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">crf_axes</span>,</span><span class=\"param\">\t<span class=\"n\">crf_points</span>,</span><span class=\"param\">\t<span class=\"n\">efc_cogs</span>,</span><span class=\"param\">\t<span class=\"n\">expected_lat_poca</span>,</span><span class=\"param\">\t<span class=\"n\">expected_lon_poca</span>,</span><span class=\"param\">\t<span class=\"n\">expected_elev_poca</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin.test_get_crf_in_efc_valid", "modulename": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "qualname": "test_get_crf_in_efc_valid", "kind": "function", "doc": "<p>Test get_crf_in_efc with valid inputs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">alt</span>, </span><span class=\"param\"><span class=\"n\">vel_vec</span>, </span><span class=\"param\"><span class=\"n\">expected_crf_axes</span>, </span><span class=\"param\"><span class=\"n\">expected_efc_cog</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin.test_get_crf_in_efc_invalid", "modulename": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "qualname": "test_get_crf_in_efc_invalid", "kind": "function", "doc": "<p>Test get_crf_in_efc function with invalid inputs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">alt</span>, </span><span class=\"param\"><span class=\"n\">vel_vec</span>, </span><span class=\"param\"><span class=\"n\">expected_error</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin.test_compute_poca_geodetic_coords_invalid", "modulename": "clev2er.utils.cristal.reloc_sarin.tests.test_reloc_sarin", "qualname": "test_compute_poca_geodetic_coords_invalid", "kind": "function", "doc": "<p>Test compute_poca_geodetic_coords with invalid inputs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">crf_axes</span>, </span><span class=\"param\"><span class=\"n\">crf_points</span>, </span><span class=\"param\"><span class=\"n\">efc_cogs</span>, </span><span class=\"param\"><span class=\"n\">expected_error</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality", "modulename": "clev2er.utils.cristal.waveform_quality", "kind": "module", "doc": "<p>CRISTAL Waveform Quality Modules</p>\n"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests", "modulename": "clev2er.utils.cristal.waveform_quality.tests", "kind": "module", "doc": "<p>CRISTAL Module Tests</p>\n"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "modulename": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "kind": "module", "doc": "<p>Module: pytest of clev2er.utils.cristal.waveform_quality.waveform_qc_checks</p>\n\n<p>This module contains pytest functions to test various waveform quality control (QC) checks \nincluding noise power, waveform power, variance, peakiness, and coherence. Each function tests\ndifferent aspects of waveform QC using the corresponding QC functions from the <code>waveform_qc_checks</code> \nmodule.</p>\n\n<hr />\n\n<h2 id=\"test_noise_power\">test_noise_power</h2>\n\n<p>test_noise_power(waveform_name): Tests noise_power_test on predefined waveforms, comparing results \nto thresholds.</p>\n\n<p>test_noise_power_empty(): Tests noise_power_test on an empty waveform, expecting a ValueError.</p>\n\n<p>test_noise_power_invalid_params(waveform, noise_startgate, noise_endgate, noise_hi): Tests invalid \nparams, expecting IndexError or ValueError.</p>\n\n<p>test_noise_power_type_error(waveform, noise_startgate, noise_endgate, noise_hi): Tests with \nincorrect data types, expecting an exception.</p>\n\n<hr />\n\n<h2 id=\"test_waveform_power\">test_waveform_power</h2>\n\n<p>test_waveform_power(waveform_name): Tests waveform_power_test on predefined waveforms, comparing \npower threshold results.</p>\n\n<p>test_waveform_power_empty(): Tests waveform_power_test on an empty waveform, expecting a ValueError.</p>\n\n<p>test_waveform_power_invalid_params(waveform, power_startgate, power_endgate, power_lo, \nnoise_startgate, noise_endgate): Tests invalid params, expecting IndexError or ValueError.</p>\n\n<p>test_waveform_power_type_error(waveform, power_startgate, power_endgate, power_lo, noise_startgate, \nnoise_endgate): Tests with incorrect data types, expecting an exception.</p>\n\n<hr />\n\n<h2 id=\"test_waveform_variance\">test_waveform_variance</h2>\n\n<p>test_variance(waveform_name): Tests waveform_variance_test on predefined waveforms, checking \nvariance threshold results.</p>\n\n<p>test_waveform_variance_empty(): Tests waveform_variance_test on an empty waveform, expecting a \nValueError.</p>\n\n<p>test_waveform_variance_invalid_params(waveform, power_startgate, power_endgate, n_samples, \nvariance_hi, expected_exception): Tests invalid params, expecting IndexError or ValueError.</p>\n\n<p>test_waveform_variance_type_error(waveform, power_startgate, power_endgate, n_samples, \nvariance_hi): Tests with incorrect data types, expecting an exception.</p>\n\n<hr />\n\n<h2 id=\"test_peakiness\">test_peakiness</h2>\n\n<p>test_peakiness(waveform_name): Tests peakiness_test on predefined waveforms, comparing peakiness \nthresholds.</p>\n\n<p>test_peakiness_empty_waveform(): Tests peakiness_test on an empty waveform, expecting a ValueError.</p>\n\n<p>test_peakiness_invalid_params(waveform, n_samples, trackingpoint, peakiness_lo, peakiness_hi, \nexpected_exception): Tests invalid params, expecting IndexError or ValueError.</p>\n\n<p>test_peakiness_type_error(waveform, n_samples, trackingpoint, peakiness_lo, peakiness_hi): Tests \nwith incorrect data types, expecting an exception.</p>\n"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks.test_noise_power", "modulename": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "qualname": "test_noise_power", "kind": "function", "doc": "<p>Test noise power QC using noise_power_test.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks.test_waveform_power", "modulename": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "qualname": "test_waveform_power", "kind": "function", "doc": "<p>Test waveform power QC using waveform_power_test.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks.test_variance", "modulename": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "qualname": "test_variance", "kind": "function", "doc": "<p>Test variance QC using waveform_variance_test.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks.test_peakiness", "modulename": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "qualname": "test_peakiness", "kind": "function", "doc": "<p>Test peakiness QC using peakiness_test.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks.test_coherence", "modulename": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "qualname": "test_coherence", "kind": "function", "doc": "<p>Test coherence QC using coherence_test.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks.test_waveform_qc", "modulename": "clev2er.utils.cristal.waveform_quality.tests.test_waveform_qc_checks", "qualname": "test_waveform_qc", "kind": "function", "doc": "<p>Comprehensive test for the waveform_qc_test function.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">qc_set</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "kind": "module", "doc": "<p>clev2er.utils.cristal.waveform_quality.waveform_qc_checks.py\nclass to perform waveform qc checks</p>\n"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks.normalize_waveform", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "qualname": "normalize_waveform", "kind": "function", "doc": "<p>Normalize the input waveform to a range of [0, 1].</p>\n\n<p>This function scales the waveform so that the maximum value is 1. If the maximum\nvalue is 0, the function returns the original waveform to avoid division by zero.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>waveform (numpy.ndarray):</strong>  1D array of waveform data to be normalized.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>numpy.ndarray: Normalized waveform where the maximum value is 1, or the\n  original waveform if the maximum value is 0.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks.noise_power_test", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "qualname": "noise_power_test", "kind": "function", "doc": "<p>Determines if a waveform fails the noise power test by comparing the average noise power\nto a specified high threshold.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>waveform (numpy.ndarray):</strong>  2D array of waveform data.</li>\n<li><strong>noise_startgate (int):</strong>  Start index for noise measurement.</li>\n<li><strong>noise_endgate (int):</strong>  End index for noise measurement.</li>\n<li><strong>noise_hi (float):</strong>  Threshold for excessive noise power.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple:\n      - bool: False if the average noise power exceeds the threshold, True otherwise.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform</span>, </span><span class=\"param\"><span class=\"n\">noise_startgate</span>, </span><span class=\"param\"><span class=\"n\">noise_endgate</span>, </span><span class=\"param\"><span class=\"n\">noise_hi</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks.waveform_power_test", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "qualname": "waveform_power_test", "kind": "function", "doc": "<p>Tests if the average power of a waveform within a specified range is lower\nthan a given threshold relative to the noise power.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>waveform (numpy.ndarray):</strong>  2D array of waveform data.</li>\n<li><strong>power_startgate (int):</strong>  Start index for power measurement.</li>\n<li><strong>power_endgate (int):</strong>  End index for power measurement.</li>\n<li><strong>power_lo (float):</strong>  Minimum acceptable power-to-noise ratio.</li>\n<li><strong>noise_startgate (int):</strong>  Start index for noise measurement.</li>\n<li><strong>noise_endgate (int):</strong>  End index for noise measurement.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>bool: False if the average waveform power divided by the noise power is below the\n  threshold, True otherwise.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">waveform</span>,</span><span class=\"param\">\t<span class=\"n\">power_startgate</span>,</span><span class=\"param\">\t<span class=\"n\">power_endgate</span>,</span><span class=\"param\">\t<span class=\"n\">power_lo</span>,</span><span class=\"param\">\t<span class=\"n\">noise_startgate</span>,</span><span class=\"param\">\t<span class=\"n\">noise_endgate</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks.waveform_variance_test", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "qualname": "waveform_variance_test", "kind": "function", "doc": "<p>Tests if the variance of a waveform within a specified range exceeds a given threshold.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>waveform (numpy.ndarray):</strong>  2D array of waveform data.</li>\n<li><strong>power_startgate (int):</strong>  Start index for power measurement.</li>\n<li><strong>power_endgate (int):</strong>  End index for power measurement.</li>\n<li><strong>n_samples (int):</strong>  Number of samples used for variance calculation.</li>\n<li><strong>variance_hi (float):</strong>  Threshold above which the variance is considered high.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>bool: False if the variance of the waveform is greater than the threshold, True otherwise.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform</span>, </span><span class=\"param\"><span class=\"n\">power_startgate</span>, </span><span class=\"param\"><span class=\"n\">power_endgate</span>, </span><span class=\"param\"><span class=\"n\">n_samples</span>, </span><span class=\"param\"><span class=\"n\">variance_hi</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks.peakiness_test", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "qualname": "peakiness_test", "kind": "function", "doc": "<p>Evaluates the peakiness of a waveform by comparing its peak-to-mean ratio\nto a specified range of acceptable values.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>waveform (numpy.ndarray):</strong>  2D array of waveforms, with each row representing a waveform.</li>\n<li><strong>n_samples (int):</strong>  Total number of samples per waveform.</li>\n<li><strong>trackingpoint (int):</strong>  Index used for calculating peakiness.</li>\n<li><strong>peakiness_lo (float):</strong>  Minimum acceptable peakiness value.</li>\n<li><strong>peakiness_hi (float):</strong>  Maximum acceptable peakiness value.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>bool: False if the calculated peakiness is outwith the acceptable range, True otherwise.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">waveform</span>, </span><span class=\"param\"><span class=\"n\">n_samples</span>, </span><span class=\"param\"><span class=\"n\">trackingpoint</span>, </span><span class=\"param\"><span class=\"n\">peakiness_lo</span>, </span><span class=\"param\"><span class=\"n\">peakiness_hi</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks.coherence_test", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "qualname": "coherence_test", "kind": "function", "doc": "<p>Tests if the maximum value of the coherence is less than the specified threshold.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>coherence (numpy.ndarray):</strong>  Array of coherence values.</li>\n<li><strong>K_coherence_lo (float):</strong>  Minimum acceptable coherence threshold.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>bool: False if max(coherence) &lt; coherence_lo, True otherwise.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">coherence</span>, </span><span class=\"param\"><span class=\"n\">coherence_lo</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks.waveform_qc_test", "modulename": "clev2er.utils.cristal.waveform_quality.waveform_qc_checks", "qualname": "waveform_qc_test", "kind": "function", "doc": "<p>Performs a series of quality control tests on multiple waveforms to determine if they pass\nvarious criteria related to noise power, waveform power, variance, and peakiness.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>noise_endgate (int):</strong>  End index for noise measurement.</li>\n<li><strong>noise_hi (float):</strong>  Threshold for high noise power.</li>\n<li><strong>noise_startgate (int):</strong>  Start index for noise measurement.</li>\n<li><strong>peakiness_hi (float):</strong>  Maximum acceptable peakiness.</li>\n<li><strong>peakiness_lo (float):</strong>  Minimum acceptable peakiness.</li>\n<li><strong>power_endgate (int):</strong>  End index for power measurement.</li>\n<li><strong>power_lo (float):</strong>  Minimum acceptable power-to-noise ratio.</li>\n<li><strong>power_startgate (int):</strong>  Start index for power measurement.</li>\n<li><strong>trackingpoint (int):</strong>  Index for peakiness calculation.</li>\n<li><strong>variance_hi (float):</strong>  Threshold above which the variance is considered high.</li>\n<li><strong>waveform (numpy.ndarray):</strong>  2D array of waveforms with waveform power in Watts to test.</li>\n<li><strong>coherence (numpy.ndarray):</strong>  2D array of interferometric coherence with shape\n(time, samples_ov) #optional, only used for Ku Band in Interferometric Mode.</li>\n<li><strong>coherence_lo(float):</strong>  Minimum coherence threshold #optional, only used for Ku Band in\nInterferometric Mode.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>waveforms_ok (numpy.ndarray) : A boolean array where each index indicates\n              whether the corresponding waveform passed all quality control tests.\n              False means the waveform is unsuitable, True means the waveform meets\n              QC requirements.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">noise_endgate</span>,</span><span class=\"param\">\t<span class=\"n\">noise_hi</span>,</span><span class=\"param\">\t<span class=\"n\">noise_startgate</span>,</span><span class=\"param\">\t<span class=\"n\">peakiness_hi</span>,</span><span class=\"param\">\t<span class=\"n\">peakiness_lo</span>,</span><span class=\"param\">\t<span class=\"n\">power_endgate</span>,</span><span class=\"param\">\t<span class=\"n\">power_lo</span>,</span><span class=\"param\">\t<span class=\"n\">power_startgate</span>,</span><span class=\"param\">\t<span class=\"n\">trackingpoint</span>,</span><span class=\"param\">\t<span class=\"n\">variance_hi</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms_scaled</span>,</span><span class=\"param\">\t<span class=\"n\">coherence</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">coherence_lo</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cs2", "modulename": "clev2er.utils.cs2", "kind": "module", "doc": "<p><strong>CS2 specific modules</strong></p>\n"}, {"fullname": "clev2er.utils.cs2.backscatter", "modulename": "clev2er.utils.cs2.backscatter", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.cs2.backscatter.backscatter", "modulename": "clev2er.utils.cs2.backscatter.backscatter", "kind": "module", "doc": "<p>Functions to compute backscatter.</p>\n\n<h2 id=\"functions\">Functions:</h2>\n\n<p>def cs_counts_to_watts( pwr_cnt, lin_fact, pow2_fact ):\n    Converts from counts to watts.</p>\n\n<p>def compute_backscatter( rx_pow_w, range_m, roll_deg, pitch_deg, tx_pow_w,\n                         ellipse_semi_major_m = 6378137.0, speed_of_light_ms = 2.99792458E+08,\n                         effective_pulse_len_s = 4.183e-9, ant_gain_linear = 18197.008586099826, \n                         wavelength_m = 2.2084e-2,\n                         bandwidth_hz = 320.0e6, beam_angle_az_deg = 1.06, \n                         beam_angle_el_deg = 1.1992,\n                         misp_roll_bias_deg = 0, misp_pitch_bias_deg = 0,\n                         sigma_bias = 0, sigma_loss_const_db = 0,\n                         misp_mode = 0, rough_mode = 0 ):\n    Converts watts to backscatter using range, transmitted power, and pointing information. </p>\n\n<h2 id=\"unit-tests\">Unit Tests:</h2>\n\n<p>The __main__ section includes the unit tests of the retracker.\nThese are run from the command line as follows:</p>\n\n<blockquote>\n  <p>python backscatter</p>\n</blockquote>\n"}, {"fullname": "clev2er.utils.cs2.backscatter.backscatter.cs_counts_to_watts", "modulename": "clev2er.utils.cs2.backscatter.backscatter", "qualname": "cs_counts_to_watts", "kind": "function", "doc": "<p>Convert CryoSat2 waveform counts to Watts.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>pwr_cnt : float\n    Power in waveform counts.\nlin_fact : float\n    Linear conversion factor from L1b data ('echo_scale_factor')\npow2_fact : float\n    Power of 2 conversion factor from L1b data ('echo_scale_pwr').</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>float\n    Power in Watts measured at the antenna.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">pwr_cnt</span>, </span><span class=\"param\"><span class=\"n\">lin_fact</span>, </span><span class=\"param\"><span class=\"n\">pow2_fact</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cs2.backscatter.backscatter.compute_backscatter", "modulename": "clev2er.utils.cs2.backscatter.backscatter", "qualname": "compute_backscatter", "kind": "function", "doc": "<p>Compute backscatter from measured power and range, with optional corrections\nfor mispointing and roughness.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>rx_pow_w : float\n    Measured received power in watts\nrange_m : float\n    Measured range to the surface in meters.\nroll_deg : float\n    Roll angle of the platform in degrees.\npitch_deg : float\n    Pitch angle of the platform in degrees.\ntx_pow_w : float\n    Transmitted power in watts.\nellipse_semi_major_m : float\n    Semi-major axis of the ellipsoid in meters. Defaults to WGS84.\nspeed_of_light_ms : float\n    Speed of light in meters. Defaults to standard value.\neffective_pulse_len_s : float\n    Effective pulse length of the transmitted pulse. Defaults to the CS2 value.\nant_gain_linear : float\n    Antenna gain expressed in linear units (not dB). Defaults to the CS2 value.\nwavelength_m : float\n    Wavelength of the altimeter in meters. Defaults to the CS2 value.\nbandwidth_hz : float\n    Bandwidth of the pulse in hertz. Defaults to the CS2 value.\nbeam_angle_az_deg : float\n    Azimuth beam angle of the elliptical antenna pattern. Defaults to the CS2 value.\nbeam_angle_el_deg : float\n    Elevation beam angle of the elliptical antenna pattern. Defaults to the CS2 value.\nmisp_roll_bias_deg : float\n    Optional bias to apply to measured roll. Defaults to zero.\nmisp_pitch_bias_deg : type\n    Optional bias to apply to measured pitch. Defaults to zero.\nsigma_bias : type\n    Optional bias to apply to returned backscatter. Defaults to zero.\nsigma_loss_const_db : type\n    Optional loss constant to apply to returned backscatter. Defaults to zero.\nmisp_mode : int\n    Method to use to compensate for the mispointing. Defaults to 0 (no compensation)\nrough_mode : int\n    Method to use to compensate for the surface roughness. Defaults to 0 (no compensation)</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>float\n    Computed surface backscatter in dB.</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<p>A simple usage example:</p>\n\n<p>watts = cs_counts_to_watts( counts, echo_scale_factor, echo_scale_pwr )\nsigma0 = compute_backscatter( watts, range_m, roll_deg, pitch_deg, tx_pow_w )</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">rx_pow_w</span>,</span><span class=\"param\">\t<span class=\"n\">range_m</span>,</span><span class=\"param\">\t<span class=\"n\">roll_deg</span>,</span><span class=\"param\">\t<span class=\"n\">pitch_deg</span>,</span><span class=\"param\">\t<span class=\"n\">tx_pow_w</span>,</span><span class=\"param\">\t<span class=\"n\">ellipse_semi_major_m</span><span class=\"o\">=</span><span class=\"mf\">6378137.0</span>,</span><span class=\"param\">\t<span class=\"n\">speed_of_light_ms</span><span class=\"o\">=</span><span class=\"mf\">299792458.0</span>,</span><span class=\"param\">\t<span class=\"n\">effective_pulse_len_s</span><span class=\"o\">=</span><span class=\"mf\">4.183e-09</span>,</span><span class=\"param\">\t<span class=\"n\">ant_gain_linear</span><span class=\"o\">=</span><span class=\"mf\">18197.008586099826</span>,</span><span class=\"param\">\t<span class=\"n\">wavelength_m</span><span class=\"o\">=</span><span class=\"mf\">0.022084</span>,</span><span class=\"param\">\t<span class=\"n\">bandwidth_hz</span><span class=\"o\">=</span><span class=\"mf\">320000000.0</span>,</span><span class=\"param\">\t<span class=\"n\">beam_angle_az_deg</span><span class=\"o\">=</span><span class=\"mf\">1.06</span>,</span><span class=\"param\">\t<span class=\"n\">beam_angle_el_deg</span><span class=\"o\">=</span><span class=\"mf\">1.1992</span>,</span><span class=\"param\">\t<span class=\"n\">misp_roll_bias_deg</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">misp_pitch_bias_deg</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">sigma_bias</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">sigma_loss_const_db</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">misp_mode</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">rough_mode</span><span class=\"o\">=</span><span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cs2.waveform_quality", "modulename": "clev2er.utils.cs2.waveform_quality", "kind": "module", "doc": "<p>**CS2 Waveform Quality Modules</p>\n"}, {"fullname": "clev2er.utils.cs2.waveform_quality.waveform_qc_checks", "modulename": "clev2er.utils.cs2.waveform_quality.waveform_qc_checks", "kind": "module", "doc": "<p>Waveform QC checks for CryoSat</p>\n"}, {"fullname": "clev2er.utils.cs2.waveform_quality.waveform_qc_checks.sarin_waveform_qc_checks", "modulename": "clev2er.utils.cs2.waveform_quality.waveform_qc_checks", "qualname": "sarin_waveform_qc_checks", "kind": "function", "doc": "<p>Inputs:\npwr_waveform_20_ku   :  numpy.ndarray of shape (num_measurements, waveform_numbins).\n                waveform_numbins is 128 (LRM) or 1024 (SIN)\n               This is the array returned by :\n               waveforms = nc.variables['pwr_waveform_20_ku'][:].data</p>\n\n<p>Return values:</p>\n\n<p>waveforms_ok :  boolean array of True (waveform ok), False (waveform not suitable)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">pwr_waveform_20_ku</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">echo_scale_factor_20_ku</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">echo_scale_pwr_20_ku</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">noise_power_20_ku</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">total_power_threshold</span><span class=\"o\">=</span><span class=\"mf\">5e-17</span>,</span><span class=\"param\">\t<span class=\"n\">low_peakiness_threshold</span><span class=\"o\">=</span><span class=\"mf\">0.9</span>,</span><span class=\"param\">\t<span class=\"n\">low_position_max_power</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">high_position_max_power</span><span class=\"o\">=</span><span class=\"mi\">1011</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.cs2.waveform_quality.waveform_qc_checks.lrm_waveform_qc_checks", "modulename": "clev2er.utils.cs2.waveform_quality.waveform_qc_checks", "qualname": "lrm_waveform_qc_checks", "kind": "function", "doc": "<p>Inputs:\npwr_waveform_20_ku   :  numpy.ndarray of shape (num_measurements, waveform_numbins).\n                waveform_numbins is 128 (LRM) or 1024 (SIN)\n               This is the array returned by :\n               waveforms = nc.variables['pwr_waveform_20_ku'][:].data</p>\n\n<p>Return values:</p>\n\n<p>waveforms_ok :  boolean array of True (waveform ok), False (waveform not suitable)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">pwr_waveform_20_ku</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">echo_scale_factor_20_ku</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">echo_scale_pwr_20_ku</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">total_power_threshold</span><span class=\"o\">=</span><span class=\"mf\">3e-16</span>,</span><span class=\"param\">\t<span class=\"n\">low_peakiness_threshold</span><span class=\"o\">=</span><span class=\"mf\">0.85</span>,</span><span class=\"param\">\t<span class=\"n\">high_peakiness_threshold</span><span class=\"o\">=</span><span class=\"mf\">2.8</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding", "modulename": "clev2er.utils.gridding", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.gridding.db", "modulename": "clev2er.utils.gridding.db", "kind": "module", "doc": "<p>Logic for generating the gridded product database.</p>\n"}, {"fullname": "clev2er.utils.gridding.db.build_s2_to_l2_mapping", "modulename": "clev2er.utils.gridding.db", "qualname": "build_s2_to_l2_mapping", "kind": "function", "doc": "<p>Generate gridded product database.</p>\n\n<p>The process of creating an L3 gridded product requires that the data included within a large\nnumber of L2 products be rearranged before it can be used to calculate the posting values within\nthe gridded product. In general, each posting within an L3 gridded product might be contributed\nto by tens to hundreds of separate L2 stripfiles depending on the configuration of the\nprocessing chain. Therefore, as an essential first step to gridding, a geospatial database of L2\nstripfiles is required. This function constructs that database.</p>\n\n<p>Within this algorithm, the header of each L2 stripfile is read and a map of S2 geospatial index\n-> L2 stripfiles intersecting that index is constructed. The exact S2 level at which this index\nis constructed will depend on the gridded product resolution (i.e. the distance between adjacent\npostings), with the intent being that there is approximately one geospatial index per posting.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>list_of_l2_file_paths (List[str]):</strong>  List of L2 files from which the mapping should be built</li>\n<li><strong>target_s2_level (int):</strong>  S2 indexing level at which the mapping should be built. Should be\nequal or coarser than the S2 indexing used to generate the L2 file\ns2 header information.</li>\n<li><strong>max_multiprocessing_workers (int):</strong>  Max number of processes to use when parallelising this\ncalculation.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Dict[np.int64, List[Tuple[str, Tuple[int, int]]]]: A dictionary where the key is an S2 index\n                  ID at the target S2 level, and the value is a list with items of the format\n                  (input_l2_file_path, row_range_tuple), representing the portions of all\n                  input files which contain data relevant to this S2 cell.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">list_of_l2_file_paths</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">target_s2_level</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">max_multiprocessing_workers</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">int64</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.grid_calculation", "modulename": "clev2er.utils.gridding.grid_calculation", "kind": "module", "doc": "<p>clev2er.utils.gridding.grid_calculation.py</p>\n\n<p>Contains logic used to calculate gridded postings (specific points on the planet corresponding to\nthe centre of a gridded product pixel) which should be generated by the gridding tool.</p>\n"}, {"fullname": "clev2er.utils.gridding.grid_calculation.calculate_grid_postings", "modulename": "clev2er.utils.gridding.grid_calculation", "qualname": "calculate_grid_postings", "kind": "function", "doc": "<p>Algorithm to generate gridded product postings.</p>\n\n<p>In order to generate a gridded product, a number of gridded postings (specific points on the\nplanet corresponding to the centre of a gridded product pixel) must be generated. The exact\nposition of these gridded postings depends on the resolution, orientation, size and projection\nof the desired gridded product. This algorithm generates the posting positions.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config (Dict):</strong>  The portion of the config passed to the gridding tool under the key\n'grid_posting_calculation'. Contains:\n    - latitude of bottom left corner in degrees\n    - longitude of bottom left corner in degrees\n    - bearing of y axis in degrees\n    - unit vector conversion offset in meters\n    - X axis resolution in  meters\n    - Y axis resolution in meters\n    - X axis extent in meters\n    - Y axis extent in meters</li>\n<li><strong>tranformer_from_4326_to_gridded_product_crs (Transformer):</strong>  Transformer from EPSG:4326 to the\nconfigured gridded product CRS</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>List[Tuple[float, float]]: Gridded product CRS x, y coordinates representing the postings of\n                             the gridded product</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Dict</span>,</span><span class=\"param\">\t<span class=\"n\">tranformer_from_4326_to_gridded_product_crs</span><span class=\"p\">:</span> <span class=\"n\">pyproj</span><span class=\"o\">.</span><span class=\"n\">transformer</span><span class=\"o\">.</span><span class=\"n\">Transformer</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.load_gridding_config", "modulename": "clev2er.utils.gridding.load_gridding_config", "kind": "module", "doc": "<p>utils.gridding.load_gridding_config.py</p>\n\n<p>Functions used to load and validate the gridding config passed into the gridding tool.</p>\n"}, {"fullname": "clev2er.utils.gridding.load_gridding_config.load_gridding_config", "modulename": "clev2er.utils.gridding.load_gridding_config", "qualname": "load_gridding_config", "kind": "function", "doc": "<p>Load configuration from XML file into dictionary.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config_file (str):</strong>  Path of XML config file</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>OSError:</strong>  If file does not exist or is not in valid XML format</li>\n<li><strong>ValueError:</strong>  If file is not XML</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Dict: Loaded configuration</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">config_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.posting_calculation", "modulename": "clev2er.utils.gridding.posting_calculation", "kind": "module", "doc": "<p>clev2er.utils.gridding.posting_calculation.py</p>\n\n<p>Contains logic for computing the gridded elevation value of a posting.</p>\n"}, {"fullname": "clev2er.utils.gridding.posting_calculation.calculate_posting", "modulename": "clev2er.utils.gridding.posting_calculation", "qualname": "calculate_posting", "kind": "function", "doc": "<p>Compute the gridded elevation value for a posting.</p>\n\n<h6 id=\"this-function\">This function:</h6>\n\n<blockquote>\n  <p>1) Determines the S2 indices at the specified level which overlap the posting area.\n  2) Retrieves data relevant to the computed S2 indices by making use of the database\n  produced by clev2er.utils.gridding.db.py::build_s2_to_l2_mapping().\n  3) Filters the retrieved data down to points within the posting area as some of the computed\n  S2 indices will only overlap with this.\n  4) Calculate the gridded elevation value for the posting by applying its kernel function to\n  the filtered data.</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>posting (Point):</strong>  Point representing the posting center in the target gridded product CRS</li>\n<li><strong>posting_kernel_radius_m (float):</strong>  Kernel radius of posting, in meters</li>\n<li><strong>s2_level (int):</strong>  S2 indexing level to use for gridding. Should match level at which the S2\nto L2 mapping was created</li>\n<li><strong>s2_to_l2_mapping (Dict[np.int64, List[Tuple[str, Tuple[int, int]]]]):</strong>  Mapping describing\nrelevant portions of L2 files for each S2 index. Generated using\nclev2er.utils.gridding.db.py::build_s2_to_l2_mapping().</li>\n<li><strong>gridded_product_crs_to_epsg_4326_transformer (Transformer):</strong>  Transformer from target CRS\nto EPSG:4326</li>\n<li><strong>epsg_4326_to_gridded_product_crs_transformer (Transformer):</strong>  Transformer from EPSG:4326 to\ntarget CRS.</li>\n<li><strong>create_debug_plots (bool):</strong>  If true, debugging plots are generated.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple[Point, float]: The posting and its computed gridded elevation value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">posting</span><span class=\"p\">:</span> <span class=\"n\">shapely</span><span class=\"o\">.</span><span class=\"n\">geometry</span><span class=\"o\">.</span><span class=\"n\">point</span><span class=\"o\">.</span><span class=\"n\">Point</span>,</span><span class=\"param\">\t<span class=\"n\">posting_kernel_radius_m</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">s2_level</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">s2_to_l2_mapping</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">int64</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">gridded_product_crs_to_epsg_4326_transformer</span><span class=\"p\">:</span> <span class=\"n\">pyproj</span><span class=\"o\">.</span><span class=\"n\">transformer</span><span class=\"o\">.</span><span class=\"n\">Transformer</span>,</span><span class=\"param\">\t<span class=\"n\">epsg_4326_to_gridded_product_crs_transformer</span><span class=\"p\">:</span> <span class=\"n\">pyproj</span><span class=\"o\">.</span><span class=\"n\">transformer</span><span class=\"o\">.</span><span class=\"n\">Transformer</span>,</span><span class=\"param\">\t<span class=\"n\">create_debug_plots</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">shapely</span><span class=\"o\">.</span><span class=\"n\">geometry</span><span class=\"o\">.</span><span class=\"n\">point</span><span class=\"o\">.</span><span class=\"n\">Point</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests", "modulename": "clev2er.utils.gridding.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.gridding.tests.test_db", "modulename": "clev2er.utils.gridding.tests.test_db", "kind": "module", "doc": "<p>pytests of util clev2er.utils.gridding.db.py.</p>\n\n<p>Tests gridding tool component responsible for building the S2 to L2 lookup table.</p>\n"}, {"fullname": "clev2er.utils.gridding.tests.test_db.test__merge_row_ranges", "modulename": "clev2er.utils.gridding.tests.test_db", "qualname": "test__merge_row_ranges", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.db.py function _merge_row_ranges</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_row_ranges</span>, </span><span class=\"param\"><span class=\"n\">expected_output_row_ranges</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_db.test__s2_to_coarser_level_valid", "modulename": "clev2er.utils.gridding.tests.test_db", "qualname": "test__s2_to_coarser_level_valid", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.db.py function _s2_to_coarser_level with valid input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_db.test__s2_to_coarser_level_invalid", "modulename": "clev2er.utils.gridding.tests.test_db", "qualname": "test__s2_to_coarser_level_invalid", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.db.py function _s2_to_coarser_level with invalid input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_db.test__get_s2_details_from_file_header", "modulename": "clev2er.utils.gridding.tests.test_db", "qualname": "test__get_s2_details_from_file_header", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.db.py function _get_s2_details_from_file_header.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tmpdir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_db.test__get_s2_row_ranges_in_file_at_level", "modulename": "clev2er.utils.gridding.tests.test_db", "qualname": "test__get_s2_row_ranges_in_file_at_level", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.db.py function _get_s2_row_ranges_in_file_at_level.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">mock_s2_indices_in_file</span>, </span><span class=\"param\"><span class=\"n\">target_s2_level</span>, </span><span class=\"param\"><span class=\"n\">expected_output_ranges</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_db.test_make_s2_to_l2_mapping", "modulename": "clev2er.utils.gridding.tests.test_db", "qualname": "test_make_s2_to_l2_mapping", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.db.py function make_s2_to_l2_mapping.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_grid_calculation", "modulename": "clev2er.utils.gridding.tests.test_grid_calculation", "kind": "module", "doc": "<p>pytest of algorithm\nclev2er.utils.gridding.grid_calculation.py</p>\n\n<p>Tests the logic that generates the gridded product postings.</p>\n"}, {"fullname": "clev2er.utils.gridding.tests.test_grid_calculation.test_calculate_grid_postings", "modulename": "clev2er.utils.gridding.tests.test_grid_calculation", "qualname": "test_calculate_grid_postings", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.grid_calculation.py</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lat_bottom_left_deg</span>,</span><span class=\"param\">\t<span class=\"n\">long_bottom_left_deg</span>,</span><span class=\"param\">\t<span class=\"n\">x_axis_extent_m</span>,</span><span class=\"param\">\t<span class=\"n\">y_axis_extent_m</span>,</span><span class=\"param\">\t<span class=\"n\">x_axis_resolution_m</span>,</span><span class=\"param\">\t<span class=\"n\">y_axis_resolution_m</span>,</span><span class=\"param\">\t<span class=\"n\">gridded_product_crs</span>,</span><span class=\"param\">\t<span class=\"n\">expected_posting_count</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_load_gridding_config_settings", "modulename": "clev2er.utils.gridding.tests.test_load_gridding_config_settings", "kind": "module", "doc": "<p>pytest of utils.gridding.load_gridding_config.py</p>\n"}, {"fullname": "clev2er.utils.gridding.tests.test_load_gridding_config_settings.test_load_config_files", "modulename": "clev2er.utils.gridding.tests.test_load_gridding_config_settings", "qualname": "test_load_config_files", "kind": "function", "doc": "<p>pytest function for utils.gridding.load_gridding_config</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_posting_calculation", "modulename": "clev2er.utils.gridding.tests.test_posting_calculation", "kind": "module", "doc": "<p>pytest of autility\nclev2er.utils.gridding.posting_calculation.py</p>\n\n<p>Tests the logic that generates the gridded product postings.</p>\n"}, {"fullname": "clev2er.utils.gridding.tests.test_posting_calculation.test__compute_gridded_elevation_for_posting", "modulename": "clev2er.utils.gridding.tests.test_posting_calculation", "qualname": "test__compute_gridded_elevation_for_posting", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.posting_calculation.py function\n_compute_gridded_elevation_for_posting</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">posting</span>,</span><span class=\"param\">\t<span class=\"n\">points_for_posting</span>,</span><span class=\"param\">\t<span class=\"n\">posting_kernel_radius_m</span>,</span><span class=\"param\">\t<span class=\"n\">expected_gridded_elevation</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_posting_calculation.test__retrieve_data_for_s2_cells", "modulename": "clev2er.utils.gridding.tests.test_posting_calculation", "qualname": "test__retrieve_data_for_s2_cells", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.posting_calculation.py function _retrieve_data_for_s2_cells</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tmpdir</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.gridding.tests.test_posting_calculation.test_calculate_posting", "modulename": "clev2er.utils.gridding.tests.test_posting_calculation", "qualname": "test_calculate_posting", "kind": "function", "doc": "<p>test of clev2er.utils.gridding.posting_calculation.py function calculate_posting</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.logging_funcs", "modulename": "clev2er.utils.logging_funcs", "kind": "module", "doc": "<p>logging helper functions:</p>\n\n<p>get_logger() :  sets up logging system to write log.ERROR, INFO, DEBUG to separate\n                log files, and also output to stdout</p>\n"}, {"fullname": "clev2er.utils.logging_funcs.CustomFormatter", "modulename": "clev2er.utils.logging_funcs", "qualname": "CustomFormatter", "kind": "class", "doc": "<p>Custom log formatter to output error logs in red</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>logging.Formatter (str):</strong>  str defining the log format msg</li>\n</ul>\n", "bases": "logging.Formatter"}, {"fullname": "clev2er.utils.logging_funcs.CustomFormatter.__init__", "modulename": "clev2er.utils.logging_funcs", "qualname": "CustomFormatter.__init__", "kind": "function", "doc": "<p>Initialize the formatter with specified format strings.</p>\n\n<p>Initialize the formatter either with the specified format string, or a\ndefault as described above. Allow for specialized date formatting with\nthe optional datefmt argument. If datefmt is omitted, you get an\nISO8601-like (or RFC 3339-like) format.</p>\n\n<p>Use a style parameter of '%', '{' or '$' to specify that you want to\nuse one of %-formatting, <code>str.format()</code> (<code>{}</code>) formatting or\n<code>string.Template</code> formatting in your format string.</p>\n\n<p><em>Changed in version 3.2:</em>\nAdded the <code>style</code> parameter.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fmt</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">datefmt</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">style</span><span class=\"o\">=</span><span class=\"s1\">&#39;%&#39;</span></span>)</span>"}, {"fullname": "clev2er.utils.logging_funcs.CustomFormatter.format", "modulename": "clev2er.utils.logging_funcs", "qualname": "CustomFormatter.format", "kind": "function", "doc": "<p>Format the specified record as text.</p>\n\n<p>The record's attribute dictionary is used as the operand to a\nstring formatting operation which yields the returned string.\nBefore formatting the dictionary, a couple of preparatory steps\nare carried out. The message attribute of the record is computed\nusing LogRecord.getMessage(). If the formatting string uses the\ntime (as determined by a call to usesTime(), formatTime() is\ncalled to format the event time. If there is exception information,\nit is formatted using formatException() and appended to the message.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">record</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.logging_funcs.get_logger", "modulename": "clev2er.utils.logging_funcs", "qualname": "get_logger", "kind": "function", "doc": "<p>Setup Logging handlers</p>\n\n<ul>\n<li>direct log.ERROR messages -> separate log file</li>\n<li>direct log.INFO (including log.ERROR, log.WARNING) -> separate log file</li>\n<li>direct log.DEBUG (including log.ERROR, log.WARNING, log.INFO) -> separate log file</li>\n<li>direct all allowed levels to stout</li>\n<li>set maximum allowed log level (applies to all outputs, default is log.INFO,</li>\n<li>ie no log.DEBUG messages will be included by default)</li>\n</ul>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>log_format (str) :</strong>  formatting string for logger</li>\n<li><strong>log_name (str) :</strong> </li>\n<li><strong>log_file_info (str) :</strong>  path of log file to use for INFO logs</li>\n<li><strong>log_file_error (str) :</strong>  path of log file to use for ERROR logs</li>\n<li><strong>log_file_debug (str) :</strong>  path of log file to use for DEBUG logs</li>\n<li><strong>default_log_level () :</strong>  default=logging.INFO</li>\n<li><strong>silent (bool) :</strong>  if True do not output to stdout, default=False</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>log object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">log_format</span><span class=\"o\">=</span><span class=\"s1\">&#39;[</span><span class=\"si\">%(levelname)-2s</span><span class=\"s1\">] : </span><span class=\"si\">%(asctime)s</span><span class=\"s1\"> : </span><span class=\"si\">%(message)s</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">log_format_debug</span><span class=\"o\">=</span><span class=\"s1\">&#39;[</span><span class=\"si\">%(levelname)-2s</span><span class=\"s1\">] : </span><span class=\"si\">%(asctime)s</span><span class=\"s1\"> : </span><span class=\"si\">%(name)-12s</span><span class=\"s1\"> :  </span><span class=\"si\">%(message)s</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">log_name</span><span class=\"o\">=</span><span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">log_file_info</span><span class=\"o\">=</span><span class=\"s1\">&#39;info.log&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">log_file_error</span><span class=\"o\">=</span><span class=\"s1\">&#39;err.log&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">log_file_debug</span><span class=\"o\">=</span><span class=\"s1\">&#39;debug.log&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">default_log_level</span><span class=\"o\">=</span><span class=\"mi\">20</span>,</span><span class=\"param\">\t<span class=\"n\">silent</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">color_errors_red</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks", "modulename": "clev2er.utils.masks", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.masks.masks", "modulename": "clev2er.utils.masks.masks", "kind": "module", "doc": "<p>Class for area masking</p>\n"}, {"fullname": "clev2er.utils.masks.masks.Mask", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask", "kind": "class", "doc": "<p>class to handle area masking</p>\n"}, {"fullname": "clev2er.utils.masks.masks.Mask.__init__", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask.__init__", "kind": "function", "doc": "<p>class initialization</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>mask_name (str):</strong>  mask name, must be in global mask_list</li>\n<li><strong>basin_numbers (list[int], optional):</strong>  list of grid values to select from grid masks\ndef=None</li>\n<li><strong>mask_path (str, optional):</strong>  override default path of mask data file</li>\n<li><strong>store_in_shared_memory (bool, optional):</strong>  stores/access mask array in SharedMemory</li>\n<li><strong>thislog (logging.Logger|None, optional):</strong>  attach to a different log instance</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">mask_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">basin_numbers</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">mask_path</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">store_in_shared_memory</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">thislog</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "clev2er.utils.masks.masks.Mask.load_netcdf_mask", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask.load_netcdf_mask", "kind": "function", "doc": "<p>load mask array from netcdf grid masks</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>mask_file (str) :</strong>  path of netcdf mask file</li>\n<li><strong>flip (bool, optional):</strong>  _description_. Defaults to True.</li>\n<li><strong>nc_mask_var (str):</strong>  variable name in netcdf file containing mask data, def='mask'</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">mask_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">flip</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">nc_mask_var</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;mask&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.masks.Mask.load_npz_mask", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask.load_npz_mask", "kind": "function", "doc": "<p>load mask array from npz grid masks</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>mask_file (str) :</strong>  path of npz mask file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">mask_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.masks.Mask.points_inside", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask.points_inside", "kind": "function", "doc": "<p>Given a list of lat,lon or x,y points, find the points that are inside the current mask</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lats (np.ndarray|list[float]):</strong>  list of latitude points</li>\n<li><strong>lons (np.ndarray|list[float]):</strong>  list of longitude points</li>\n<li><strong>basin_numbers (list[int,], optional):</strong>  list of basin numbers. Defaults to None.</li>\n<li><strong>inputs_are_xy (bool, optional):</strong>  lats, lons are already transformed to x,y.\nDefaults to False.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>inmask(np.ndarray) : boolean array same size as input list, indicating whether\n  inputs points are inside (True) or outside (False) mask\n  n_inside (int) : number inside mask</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lats</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">lons</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span> <span class=\"o\">|</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">basin_numbers</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">inputs_are_xy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.masks.Mask.grid_mask_values", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask.grid_mask_values", "kind": "function", "doc": "<p>Return the grid mask value at each input lats, lons interpolated grid location</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lats (np.ndarray):</strong>  array of latitude (N) values in degrees</li>\n<li><strong>lons (np.ndarray):</strong>  array of longitude (E) values in degrees</li>\n<li><strong>inputs_are_xy (bool):</strong>  inputs are x,y values (m) instead of latitude, longitude values</li>\n<li><strong>unknown_value (int):</strong>  value returned for locations outside mask, or where mask\ngrid includes an unclassified value (unknown_value will be\nsubstituted)</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>mask_values (np.ndarray): grid mask value at each input lats, lons interpolated\n                       grid location or np.NaN if outside area</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lats</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">lons</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">inputs_are_xy</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">unknown_value</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.masks.Mask.latlon_to_xy", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask.latlon_to_xy", "kind": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lats</strong>:  latitude points in degs</li>\n<li><strong>lons</strong>:  longitude points in degrees E</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>x,y in polar stereo projection of mask</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">lats</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>, </span><span class=\"param\"><span class=\"n\">lons</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.masks.Mask.clean_up", "modulename": "clev2er.utils.masks.masks", "qualname": "Mask.clean_up", "kind": "function", "doc": "<p>Free up, close or release any shared memory or other resources associated\nwith mask</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.pre_processors", "modulename": "clev2er.utils.masks.pre_processors", "kind": "module", "doc": "<h1 id=\"pre-processing-for-mask-file-creation\">Pre-processing for Mask file Creation</h1>\n\n<h2 id=\"dilated-antarctic-and-greenland-masks\">Dilated Antarctic and Greenland Masks</h2>\n\n<p><code>create_dilated_masks.py</code></p>\n"}, {"fullname": "clev2er.utils.masks.pre_processors.create_dilated_masks", "modulename": "clev2er.utils.masks.pre_processors.create_dilated_masks", "kind": "module", "doc": "<p>Create a dilated Antarctic mask\n    - bedmachine v2 grounded + floating 500m grid mask\n    - dilated by 10km\n    - saved as TBD format</p>\n"}, {"fullname": "clev2er.utils.masks.pre_processors.create_dilated_masks.main", "modulename": "clev2er.utils.masks.pre_processors.create_dilated_masks", "qualname": "main", "kind": "function", "doc": "<p>main function for tool</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.tests", "modulename": "clev2er.utils.masks.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.masks.tests.test_masks", "modulename": "clev2er.utils.masks.tests.test_masks", "kind": "module", "doc": "<p>pytests for masks.py: Mask class</p>\n"}, {"fullname": "clev2er.utils.masks.tests.test_masks.test_mask_points_inside", "modulename": "clev2er.utils.masks.tests.test_masks", "qualname": "test_mask_points_inside", "kind": "function", "doc": "<p>test of Mask.points_inside()</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>mask_name (str):</strong>  name of Mask</li>\n<li><strong>indices_inside (list[int]):</strong>  list of indices inside mask, or empty list []</li>\n<li><strong>num_inside (int):</strong>  number of points inside mask</li>\n<li><strong>lats (_type_):</strong>  _description_</li>\n<li><strong>lons (_type_):</strong>  _description_</li>\n<li><strong>grid_values (_type_):</strong>  _description_</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">mask_name</span>, </span><span class=\"param\"><span class=\"n\">indices_inside</span>, </span><span class=\"param\"><span class=\"n\">lats</span>, </span><span class=\"param\"><span class=\"n\">lons</span>, </span><span class=\"param\"><span class=\"n\">grid_values</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.tests.test_masks.test_mask_grid_mask_values", "modulename": "clev2er.utils.masks.tests.test_masks", "qualname": "test_mask_grid_mask_values", "kind": "function", "doc": "<p>test of Mask.grid_mask_values()</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>mask_name (str):</strong>  mask name</li>\n<li><strong>lats (np.ndarray):</strong>  array of latitude N values in degs</li>\n<li><strong>lons (np.ndarray):</strong>  array of longitude E values in degs</li>\n<li><strong>expected_surface_type (list[int or nan]):</strong>  list of expected surface type values</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>None</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">mask_name</span>, </span><span class=\"param\"><span class=\"n\">lats</span>, </span><span class=\"param\"><span class=\"n\">lons</span>, </span><span class=\"param\"><span class=\"n\">expected_surface_type</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.tests.test_masks.test_mask_loading", "modulename": "clev2er.utils.masks.tests.test_masks", "qualname": "test_mask_loading", "kind": "function", "doc": "<p>test loading mask file using non-default path</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.masks.tests.test_shm", "modulename": "clev2er.utils.masks.tests.test_shm", "kind": "module", "doc": "<p>A test of loading DEMs using shared memory</p>\n"}, {"fullname": "clev2er.utils.masks.tests.test_shm.task", "modulename": "clev2er.utils.masks.tests.test_shm", "qualname": "task", "kind": "function", "doc": "<p>child process</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.orbits", "modulename": "clev2er.utils.orbits", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.orbits.find_orbit_directions", "modulename": "clev2er.utils.orbits.find_orbit_directions", "kind": "module", "doc": "<p>find direction of track from nadir latitudes</p>\n"}, {"fullname": "clev2er.utils.orbits.find_orbit_directions.find_orbit_directions", "modulename": "clev2er.utils.orbits.find_orbit_directions", "qualname": "find_orbit_directions", "kind": "function", "doc": "<p>Returns index of the start of ascending orbit and/or desc orbit\nor None</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lats (np.ndarray) :</strong>  array of latitude values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lats</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers", "modulename": "clev2er.utils.retrackers", "kind": "module", "doc": "<h1 id=\"retracking-modules\">Retracking Modules</h1>\n"}, {"fullname": "clev2er.utils.retrackers.fastsmooth", "modulename": "clev2er.utils.retrackers.fastsmooth", "kind": "module", "doc": "<p>fastsmooth() : smoothing function port from Matlab</p>\n"}, {"fullname": "clev2er.utils.retrackers.fastsmooth.fastsmooth", "modulename": "clev2er.utils.retrackers.fastsmooth", "qualname": "fastsmooth", "kind": "function", "doc": "<p>Fixed version of fastsmooth with corrected end handling</p>\n\n<p>port of Matlab fastsmooth function, Copyright (c) 2012, Thomas C. O'Haver\n<a href=\"https://uk.mathworks.com/matlabcentral/fileexchange/19998-fast-smoothing-function?s_tid=srchtitle\">https://uk.mathworks.com/matlabcentral/fileexchange/19998-fast-smoothing-function?s_tid=srchtitle</a>\nwith taper=1, edge=1 preset</p>\n\n<p>Args:\ninput_array (np.ndarray) : input array to smooth\nsmoothwidth (int) : smoothing width</p>\n\n<p>Returns: smoothed_array (np.ndarray)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_array</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>, </span><span class=\"param\"><span class=\"n\">smoothwidth</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.find_leading_edge", "modulename": "clev2er.utils.retrackers.find_leading_edge", "kind": "module", "doc": "<p>clev2er.utils.retrackers.find_leading_edge.py</p>\n\n<p>Purpose: function to find the position of the leading edge from a\nset of altimetry waveforms</p>\n"}, {"fullname": "clev2er.utils.retrackers.find_leading_edge.find_leading_edge", "modulename": "clev2er.utils.retrackers.find_leading_edge", "qualname": "find_leading_edge", "kind": "function", "doc": "<h6 id=\"purpose\">Purpose:</h6>\n\n<blockquote>\n  <p>Find the position of the leading edge from a set of altimetry waveforms</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>retracker_config (dict):</strong>  limited dictionary containing retracker configuration params only\n{\"waveform_oversampling_factor\":int,\n \"noise_method\":str,\n \"noise_sample_limit\":int,\n \"noise_threshold\":float,\n \"leading_edge_normalized_threshold\": float,\n \"leading_edge_normalized_amplitiude_threshold\": float,\n \"svg_smoothing_width\": int,\n \"svg_poly_order\": int,\n}</li>\n<li><strong>waveforms (np.ndarray):</strong>   you can pass in a\nnumpy.ndarray of shape (num_measurements, waveform_numbins).\nexample waveform_numbins is 1024 (SIN) for CS2</li>\n<li><strong>include_mask (np.ndarray):</strong>  boolean mask of size equal to number of waveforms\nOnly retrack waveforms where this mask is True</li>\n<li><strong>plot_flag (bool, def=False):</strong>  set to True to plot waveforms and retracking points\nfor testing/debugging purposes\n(Note, blocks until each plot closed)</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple: (leading_edge_start,\n          leading_edge_stop,\n          failure_reasons)</p>\n\n<pre><code>    leading_edge_start_bins (ndarray[float]): per waveform leading edge start\n                                          coordinate in bins or Nan if not calculated\n    leading_edge_stop_bins (ndarray[float]):  per waveform leading edge stop\n                                          coordinates in bins or Nan if not calculated\n    failure_reasons (ndarray[np.uint8]: failure reasons (0=ok, 1-6=failure)\n    # failure_reasons values:\n    # 0 == successful calculation of leading edge\n    # 1 == failure due to waveform maximum count value is 0\n    # 2 == finding leading edge failed due to mean noise in noise gates above threshold\n    # 3 == leading edge not found for waveform as no samples are sufficiently above\n    #      the noise floor\n    # 4 == reached end of waveform without finding LE\n    # 5 == no waveform peak can be identified after the leading edge starts\n    # 6 == leading edge not calculated as waveform not included in input waveform mask\n</code></pre>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">retracker_config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">include_mask</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">plot_flag</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.sin_max_coherence_retracker", "modulename": "clev2er.utils.retrackers.sin_max_coherence_retracker", "kind": "module", "doc": "<p>clev2er.utils.retrackers.sin_max_coherence_retracker.py</p>\n\n<p>Purpose: function to calculate the retracking points for ku SIN\nwaveforms using the SIN Maximum Coherence retracker.</p>\n\n<p>This uses an adapted method of Leading Edge detection (M.McMillan) and\nthe LMC retracker in Aublanc et al, 2021 (Ice Sheet Topography from a\nNew CryoSat-2 SARIn Processing Chain, and Assessment by Comparison to ICESat-2\nover Antarctica)</p>\n\n<h1 id=\"functions\">Functions:</h1>\n\n<p>sin_max_coherence_retracker()</p>\n"}, {"fullname": "clev2er.utils.retrackers.sin_max_coherence_retracker.sin_max_coherence_retracker", "modulename": "clev2er.utils.retrackers.sin_max_coherence_retracker", "qualname": "sin_max_coherence_retracker", "kind": "function", "doc": "<h6 id=\"purpose\">Purpose:</h6>\n\n<blockquote>\n  <p>Find the position of the leading edge from a set of altimetry waveforms</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>retracker_config (dict):</strong>  limited dictionary containing retracker configuration params only\n{\"waveform_oversampling_factor\":int,\n \"noise_method\":str,\n \"noise_sample_limit\":int,\n \"noise_threshold\":float,\n \"leading_edge_threshold\": float,\n \"leading_edge_normalised_amplitiude_threshold\": float,\n \"svg_smoothing_width\": int,\n \"svg_poly_order\": int,\n \"svg_coherence_smoothing_width\": int,\n \"svg_poly_order_coherence\": int,\n \"retrack_smoothed_waveform\": bool,\n}</li>\n<li><strong>waveforms (np.ndarray):</strong>   you can pass in a\nnumpy.ndarray of shape (num_measurements, waveform_numbins).\nexample waveform_numbins is 1024 (SIN) for CS2</li>\n<li><strong>coherence (np.ndarray):</strong>  SIN coherence of each (num_measurements, waveform_numbins)</li>\n<li><strong>include_mask (np.ndarray):</strong>  boolean mask of size equal to number of waveforms\nOnly retrack waveforms where this mask is True</li>\n<li><strong>range_bin_size_m (np.ndarray):</strong>  bin size in m to use for each waveform</li>\n<li><strong>plot_flag (bool, def=False):</strong>  set to True to plot waveforms and retracking points\nfor testing/debugging purposes\n(Note, blocks until each plot closed)</li>\n<li><strong>plot_coherence (bool = False):</strong>  set to True to include coherence waveforms in plots</li>\n<li><strong>log (log.Logger|None):</strong>   logging instance to use</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple[\n  rtrk_range_correction_bins,\n  rtrk_range_correction_meters,\n  leading_edge_start_bin_nums,\n  leading_edge_stop_bin_nums,\n  pwr_at_rtrk_point,\n  n_rtrk_failed,\n  rtrk_failure_reasons,\n  ]</p>\n  \n  <p>rtrk_range_correction_bins (ndarray[float]): retracking point relative to nominal\n                                               tracking point in bins\n  rtrk_range_correction_meters (ndarray[float]): retracking point relative to nominal\n                                               tracking point in meters\n  leading_edge_start_bin_nums (ndarray[float]): per waveform leading edge start\n                                                coordinate in bins or Nan if not calculated\n  leading_edge_stop_bin_nums (ndarray[float]):  per waveform leading edge stop\n                                                coordinates in bins or Nan if not calculated\n  pwr_at_rtrk_point (np.ndarray): power in counts at retracking point\n  n_retrack_failed (int): number of waveforms where retracking failed\n  rtrk_failure_reasons (ndarray[np.uint8]: failure reasons (0=ok, 1-7=rtrk failure, 99=masked)\n      # rtrk_failure_reasons values:\n      # 0 == successful calculation of retracking point\n      # 1 == failure due to waveform maximum count value is 0\n      # 2 == finding leading edge failed due to mean noise in noise gates above threshold\n      # 3 == leading edge not found for waveform as no samples are sufficiently above\n      #      the noise floor\n      # 4 == reached end of waveform without finding LE\n      # 5 == no waveform peak can be identified after the leading edge starts\n      # 6 = MC retracker stage failed: top part of LE too short\n      # 7 = MC retracker stage failed: zero power found at retracking point\n      # 99 == retracking not calculated as waveform not included in input waveform mask</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">retracker_config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">coherence</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">include_mask</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">range_bin_size_m</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">plot_flag</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">plot_coherence</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tcog_retracker", "modulename": "clev2er.utils.retrackers.tcog_retracker", "kind": "module", "doc": "<p>clev2er.utils.retrackers.tcog_retracker.py</p>\n\n<p>Purpose: function to calculate the retracking points using a TCOG\n(Threshold Centre Of Gravity) retracker.</p>\n\n<h1 id=\"functions\">Functions:</h1>\n\n<p>tcog_retracker()</p>\n"}, {"fullname": "clev2er.utils.retrackers.tcog_retracker.plot_waveform", "modulename": "clev2er.utils.retrackers.tcog_retracker", "qualname": "plot_waveform", "kind": "function", "doc": "<p>plot waveform and its retracking parameters</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>waveform_num (_type_):</strong>  _description_</li>\n<li><strong>wf_bin_num_oversampled (_type_):</strong>  _description_</li>\n<li><strong>wfi (_type_):</strong>  _description_</li>\n<li><strong>wfi_sm (_type_):</strong>  _description_</li>\n<li><strong>d_wf_sm (_type_):</strong>  _description_</li>\n<li><strong>first_peak_ind (_type_):</strong>  _description_</li>\n<li><strong>le_index (_type_):</strong>  _description_</li>\n<li><strong>retrack_ind_tcog (_type_):</strong>  _description_</li>\n<li><strong>wf_noise_mean (_type_):</strong>  _description_</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">waveform_num</span>,</span><span class=\"param\">\t<span class=\"n\">wf_bin_num_oversampled</span>,</span><span class=\"param\">\t<span class=\"n\">wfi</span>,</span><span class=\"param\">\t<span class=\"n\">wfi_sm</span>,</span><span class=\"param\">\t<span class=\"n\">d_wf_sm</span>,</span><span class=\"param\">\t<span class=\"n\">first_peak_ind</span>,</span><span class=\"param\">\t<span class=\"n\">le_index</span>,</span><span class=\"param\">\t<span class=\"n\">retrack_ind_tcog</span>,</span><span class=\"param\">\t<span class=\"n\">wf_noise_mean</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tcog_retracker.tcog_retracker", "modulename": "clev2er.utils.retrackers.tcog_retracker", "qualname": "tcog_retracker", "kind": "function", "doc": "<h1 id=\"purpose\">Purpose</h1>\n\n<p>Find the position of the leading edge from a set of altimetry waveforms</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>retracker_config (dict):</strong>  limited dictionary containing retracker configuration params only\n{\"waveform_oversampling_factor\":int,\n \"noise_method\":str,\n \"noise_sample_limit\":int,\n \"noise_threshold\":float,\n \"leading_edge_threshold\": float,\n \"leading_edge_normalised_amplitiude_threshold\": float,\n \"svg_smoothing_width\": int,\n \"svg_poly_order\": int,\n \"retrack_smoothed_waveform\": bool,\n}</li>\n<li><strong>waveforms (np.ndarray):</strong>   you can pass in a\nnumpy.ndarray of shape (num_measurements, waveform_numbins).\nexample waveform_numbins is 1024 (SIN) for CS2</li>\n<li><strong>include_mask (np.ndarray):</strong>  boolean mask of size equal to number of waveforms\nOnly retrack waveforms where this mask is True</li>\n<li><strong>plot_flag (bool, def=False):</strong>  set to True to plot waveforms and retracking points\nfor testing/debugging purposes\n(Note, blocks until each plot closed)</li>\n<li><strong>log (log.Logger|None):</strong>   logging instance to use</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Tuple[\n  rtrk_range_correction_bins,\n  rtrk_range_correction_meters,\n  leading_edge_start_bin_nums,\n  leading_edge_stop_bin_nums,\n  pwr_at_rtrk_point,\n  n_rtrk_failed,\n  rtrk_failure_reasons,\n  ]</p>\n  \n  <p>rtrk_range_correction_bins (ndarray[float]): retracking point relative to nominal\n                                               tracking point in bins\n  rtrk_range_correction_meters (ndarray[float]): retracking point relative to nominal\n                                               tracking point in meters\n  leading_edge_start_bin_nums (ndarray[float]): per waveform leading edge start\n                                                coordinate in bins or Nan if not calculated\n  leading_edge_stop_bin_nums (ndarray[float]):  per waveform leading edge stop\n                                                coordinates in bins or Nan if not calculated\n  pwr_at_rtrk_point (np.ndarray): power in counts at retracking point\n  n_retrack_failed (int): number of waveforms where retracking failed\n  rtrk_failure_reasons (ndarray[np.uint8]: failure reasons (0=ok, 1-7=rtrk failure, 99=masked)\n      # rtrk_failure_reasons values:\n      # 0 == successful calculation of retracking point\n      # 1 == failure due to waveform maximum count value is 0\n      # 2 == finding leading edge failed due to mean noise in noise gates above threshold\n      # 3 == leading edge not found for waveform as no samples are sufficiently above\n      #      the noise floor\n      # 4 == reached end of waveform without finding LE\n      # 5 == no waveform peak can be identified after the leading edge starts\n      # 6 = MC retracker stage failed\n      # 7 = MC retracker stage failed\n      # 99 == retracking not calculated as waveform not included in input waveform mask</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">retracker_config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">waveforms</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">include_mask</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">range_bin_size_m</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">plot_flag</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests", "modulename": "clev2er.utils.retrackers.tests", "kind": "module", "doc": "<p>pytests for retrackers</p>\n"}, {"fullname": "clev2er.utils.retrackers.tests.test_find_leading_edge", "modulename": "clev2er.utils.retrackers.tests.test_find_leading_edge", "kind": "module", "doc": "<p>test of clev2er.utils.retrackers.find_leading_edge.py</p>\n"}, {"fullname": "clev2er.utils.retrackers.tests.test_find_leading_edge.create_waveforms", "modulename": "clev2er.utils.retrackers.tests.test_find_leading_edge", "qualname": "create_waveforms", "kind": "function", "doc": "<p>Create a set of waveforms with a flat section, rising edge, and falling edge.</p>\n\n<p>Parameters:</p>\n\n<ul>\n<li>number_of_waveforms: Number of waveforms to generate</li>\n<li>length: Length of each waveform (default is 1024)</li>\n<li>noise_floor: The constant value for the flat section (default is 0)</li>\n<li>peak_value: The peak value of the rising section (default is 1)</li>\n<li>rising_len: Length of the rising section (default is 256)</li>\n<li>falling_len: Length of the falling section (default is 256)</li>\n</ul>\n\n<p>Returns:</p>\n\n<ul>\n<li>waveforms: A numpy array of shape (number_of_waveforms, length)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">number_of_waveforms</span>,</span><span class=\"param\">\t<span class=\"n\">length</span><span class=\"o\">=</span><span class=\"mi\">1024</span>,</span><span class=\"param\">\t<span class=\"n\">noise_floor</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">peak_value</span><span class=\"o\">=</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">rising_len</span><span class=\"o\">=</span><span class=\"mi\">256</span>,</span><span class=\"param\">\t<span class=\"n\">falling_len</span><span class=\"o\">=</span><span class=\"mi\">256</span>,</span><span class=\"param\">\t<span class=\"n\">final_value</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">plot</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_find_leading_edge.test_find_leading_edge_simulated", "modulename": "clev2er.utils.retrackers.tests.test_find_leading_edge", "qualname": "test_find_leading_edge_simulated", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.find_leading_edge.py</p>\n\n<p>create a simulated good waveform which should pass and we can predict the\nleading edge positions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_find_leading_edge.test_find_leading_edge_simulated_high_noise_floor", "modulename": "clev2er.utils.retrackers.tests.test_find_leading_edge", "qualname": "test_find_leading_edge_simulated_high_noise_floor", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.find_leading_edge.py</p>\n\n<p>Test with simulated waveform where the noise floor is above threshold</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_find_leading_edge.test_find_leading_edge_simulated_no_le", "modulename": "clev2er.utils.retrackers.tests.test_find_leading_edge", "qualname": "test_find_leading_edge_simulated_no_le", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.find_leading_edge.py</p>\n\n<p>Test with simulated waveform where failure is expected to be value 5</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_find_leading_edge.test_find_leading_edge_transcoded_cs2", "modulename": "clev2er.utils.retrackers.tests.test_find_leading_edge", "qualname": "test_find_leading_edge_transcoded_cs2", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.find_leading_edge.py</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker", "modulename": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker", "kind": "module", "doc": "<p>test of clev2er.utils.retrackers.sin_max_coherence_retracker.py</p>\n"}, {"fullname": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker.create_waveforms", "modulename": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker", "qualname": "create_waveforms", "kind": "function", "doc": "<p>Create a set of waveforms with a flat section, rising edge, and falling edge.</p>\n\n<p>Parameters:</p>\n\n<ul>\n<li>number_of_waveforms: Number of waveforms to generate</li>\n<li>length: Length of each waveform (default is 1024)</li>\n<li>noise_floor: The constant value for the flat section (default is 0)</li>\n<li>peak_value: The peak value of the rising section (default is 1)</li>\n<li>rising_len: Length of the rising section (default is 256)</li>\n<li>falling_len: Length of the falling section (default is 256)</li>\n</ul>\n\n<p>Returns:</p>\n\n<ul>\n<li>waveforms: A numpy array of shape (number_of_waveforms, length)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">number_of_waveforms</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">length</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1024</span>,</span><span class=\"param\">\t<span class=\"n\">noise_floor</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">peak_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">rising_len</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">256</span>,</span><span class=\"param\">\t<span class=\"n\">falling_len</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">256</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker.test_sin_max_coherence_retracker_simulated", "modulename": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker", "qualname": "test_sin_max_coherence_retracker_simulated", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.sin_max_coherence_retracker.py</p>\n\n<p>Create simulated waveform, coherence and mask, where the retracking points can be\npredicted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker.test_sin_max_coherence_retracker_transcoded_cs2", "modulename": "clev2er.utils.retrackers.tests.test_sin_max_coherence_retracker", "qualname": "test_sin_max_coherence_retracker_transcoded_cs2", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.sin_max_coherence_retracker.py</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_tcog_retracker", "modulename": "clev2er.utils.retrackers.tests.test_tcog_retracker", "kind": "module", "doc": "<p>test of clev2er.utils.retrackers.tcog_retracker.py</p>\n"}, {"fullname": "clev2er.utils.retrackers.tests.test_tcog_retracker.create_waveforms", "modulename": "clev2er.utils.retrackers.tests.test_tcog_retracker", "qualname": "create_waveforms", "kind": "function", "doc": "<p>Create a set of waveforms with a flat section, rising edge, and falling edge.</p>\n\n<p>Parameters:</p>\n\n<ul>\n<li>number_of_waveforms: Number of waveforms to generate</li>\n<li>length: Length of each waveform (default is 1024)</li>\n<li>noise_floor: The constant value for the flat section (default is 0)</li>\n<li>peak_value: The peak value of the rising section (default is 1)</li>\n<li>rising_len: Length of the rising section (default is 256)</li>\n<li>falling_len: Length of the falling section (default is 256)</li>\n</ul>\n\n<p>Returns:</p>\n\n<ul>\n<li>waveforms: A numpy array of shape (number_of_waveforms, length)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">number_of_waveforms</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">length</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1024</span>,</span><span class=\"param\">\t<span class=\"n\">noise_floor</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">peak_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">rising_len</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">256</span>,</span><span class=\"param\">\t<span class=\"n\">falling_len</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">256</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_tcog_retracker.test_tcog_retracker_simulated", "modulename": "clev2er.utils.retrackers.tests.test_tcog_retracker", "qualname": "test_tcog_retracker_simulated", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.tcog_retracker.py</p>\n\n<p>Create simulated waveform and mask, where the retracking points can be\npredicted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.retrackers.tests.test_tcog_retracker.test_tcog_retracker_transcoded_cs2", "modulename": "clev2er.utils.retrackers.tests.test_tcog_retracker", "qualname": "test_tcog_retracker_transcoded_cs2", "kind": "function", "doc": "<p>pytest function for clev2er.utils.retrackers.tcog_retracker.py</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.testing", "modulename": "clev2er.utils.testing", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.testing.testing", "modulename": "clev2er.utils.testing.testing", "kind": "module", "doc": "<p>Helper functions for pytest testing of CLEV2ER algorithm chains</p>\n\n<p>initialize_algorithms() : Initialize all algorithms up until (and including)\n                          the algorithm under test</p>\n"}, {"fullname": "clev2er.utils.testing.testing.merge_dicts_recursive", "modulename": "clev2er.utils.testing.testing", "qualname": "merge_dicts_recursive", "kind": "function", "doc": "<p>Recursively merges two dictionaries. If both dictionaries contain a key with a\ndictionary as the value, the function will recursively merge the sub-dictionaries.\nFor other types, the value from <code>dict2</code> will overwrite the value in <code>dict1</code>.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>dict1 (Dict[str, Any]):</strong>  The first dictionary to merge.</li>\n<li><strong>dict2 (Dict[str, Any]):</strong>  The second dictionary to merge. Values from this dictionary will\noverwrite those in <code>dict1</code> if there are key conflicts (unless both values are\ndictionaries).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Dict[str, Any]: A new dictionary that is the result of recursively merging\n  <code>dict1</code> and <code>dict2</code>.</p>\n</blockquote>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">dict1</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;x&#39;</span><span class=\"p\">:</span> <span class=\"mi\">10</span><span class=\"p\">,</span> <span class=\"s1\">&#39;y&#39;</span><span class=\"p\">:</span> <span class=\"mi\">20</span><span class=\"p\">},</span> <span class=\"s1\">&#39;c&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">dict2</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;y&#39;</span><span class=\"p\">:</span> <span class=\"mi\">21</span><span class=\"p\">,</span> <span class=\"s1\">&#39;z&#39;</span><span class=\"p\">:</span> <span class=\"mi\">30</span><span class=\"p\">},</span> <span class=\"s1\">&#39;c&#39;</span><span class=\"p\">:</span> <span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s1\">&#39;d&#39;</span><span class=\"p\">:</span> <span class=\"mi\">5</span><span class=\"p\">}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">merge_dicts_recursive</span><span class=\"p\">(</span><span class=\"n\">dict1</span><span class=\"p\">,</span> <span class=\"n\">dict2</span><span class=\"p\">)</span>\n<span class=\"go\">{&#39;a&#39;: 1, &#39;b&#39;: {&#39;x&#39;: 10, &#39;y&#39;: 21, &#39;z&#39;: 30}, &#39;c&#39;: 4, &#39;d&#39;: 5}</span>\n</code></pre>\n  </div>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dict1</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">dict2</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.testing.testing.initialize_algorithms", "modulename": "clev2er.utils.testing.testing", "qualname": "initialize_algorithms", "kind": "function", "doc": "<p>Initialize all algorithms up until (and including) the algorithm under test</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>chain_name (str):</strong>  CLEV2ER chain name</li>\n<li><strong>alg_name_under_test (str):</strong>  name of algorithm under test</li>\n<li><strong>log (Logger.log) :</strong>  logger instance to use for log messages</li>\n<li><strong>config_extra (dict) :</strong>  dictionary to merge with loaded chain config</li>\n</ul>\n\n<p>Returns:  (bool,list, dict) : False (failure), list[Algorithm], config dict</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">chain_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">alg_name_under_test</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"p\">:</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Logger</span>,</span><span class=\"param\">\t<span class=\"n\">config_extra</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.testing.tests", "modulename": "clev2er.utils.testing.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.testing.tests.test_init_algs", "modulename": "clev2er.utils.testing.tests.test_init_algs", "kind": "module", "doc": "<p>Test of clev2er.utils.testing.testing.initialize_algorithms</p>\n"}, {"fullname": "clev2er.utils.testing.tests.test_init_algs.test_initialize_algorithms", "modulename": "clev2er.utils.testing.tests.test_init_algs", "qualname": "test_initialize_algorithms", "kind": "function", "doc": "<p>pytest of clev2er.utils.testing.testing.initialize_algorithms</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.time", "modulename": "clev2er.utils.time", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.time.grain", "modulename": "clev2er.utils.time.grain", "kind": "module", "doc": "<p>Author: Nick Bearson, nickb@ssec.wisc.edu\nCopyright (c) 2014 University of Wisconsin SSEC. All rights reserved.\nGet new leap second files @ <a href=\"https://www.ietf.org/timezones/data/leap-seconds.list\">https://www.ietf.org/timezones/data/leap-seconds.list</a></p>\n"}, {"fullname": "clev2er.utils.time.grain.Grain", "modulename": "clev2er.utils.time.grain", "qualname": "Grain", "kind": "class", "doc": "<p>An object for parsing and utilizing the information contained in a leap second file.\nInitialize with a file object, ie: the result of open(...)</p>\n"}, {"fullname": "clev2er.utils.time.grain.Grain.utc2tai", "modulename": "clev2er.utils.time.grain", "qualname": "Grain.utc2tai", "kind": "function", "doc": "<p>Takes datetime object (utc) and returns TAI seconds since given epoch.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">utc</span>, </span><span class=\"param\"><span class=\"n\">epoch</span><span class=\"o\">=</span><span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span><span class=\"p\">(</span><span class=\"mi\">2000</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">)</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.time.grain.Grain.tai2utc", "modulename": "clev2er.utils.time.grain", "qualname": "Grain.tai2utc", "kind": "function", "doc": "<p>Takes TAI seconds since given epoch and returns a datetime.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">seconds_since_epoch</span>, </span><span class=\"param\"><span class=\"n\">epoch</span><span class=\"o\">=</span><span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span><span class=\"p\">(</span><span class=\"mi\">2000</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">)</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.xml", "modulename": "clev2er.utils.xml", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.xml.tests", "modulename": "clev2er.utils.xml.tests", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "clev2er.utils.xml.tests.test_xml_funcs", "modulename": "clev2er.utils.xml.tests.test_xml_funcs", "kind": "module", "doc": "<p>test of xml_funcs.py functions</p>\n"}, {"fullname": "clev2er.utils.xml.tests.test_xml_funcs.test_set_xml_dict_types", "modulename": "clev2er.utils.xml.tests.test_xml_funcs", "qualname": "test_set_xml_dict_types", "kind": "function", "doc": "<p>test of set_xml_dict_types</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.xml.xml_funcs", "modulename": "clev2er.utils.xml.xml_funcs", "kind": "module", "doc": "<p>xml processing functions</p>\n"}, {"fullname": "clev2er.utils.xml.xml_funcs.replace_env_variables", "modulename": "clev2er.utils.xml.xml_funcs", "qualname": "replace_env_variables", "kind": "function", "doc": "<p>replace environment variables in str</p>\n\n<p>copes with $SOME_ENV and ${SOME_ENV} in str</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>input_str (str):</strong>  input string</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: string with env vars replaced</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">input_str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "clev2er.utils.xml.xml_funcs.set_xml_dict_types", "modulename": "clev2er.utils.xml.xml_funcs", "qualname": "set_xml_dict_types", "kind": "function", "doc": "<p>convert string values to bool, int, float in a dict parsed from xml</p>\n\n<p>xmltodict.parse(xml) creates a dictionary from the XML file\nbut it stores all dict values as type str</p>\n\n<h6 id=\"this-function-checks-each-string-and-converts-to\">This function checks each string and converts to :</h6>\n\n<blockquote>\n  <p>bool : if str == 'false' (any case) == 'true (any case)\n  int : if int(str) is valid\n  float : if float(str) is valid</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config (dict):</strong>  dictionary previously parsed by xmltodict</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>None</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();