#!/bin/bash

# Script to change the revision version in run_chain.py and pyproject.toml

# Assign the first argument to a variable
FILE=src/clev2er/tools/run_chain.py
FILE2=pyproject.toml
FILE3=native_install.sh
FILE4=docker_install.sh

# Check if the file exists
if [ ! -f "$FILE" ]; then
    echo "Error: File '$FILE' not found!"
    exit 1
fi

# Check if the file exists
if [ ! -f "$FILE2" ]; then
    echo "Error: File '$FILE2' not found!"
    exit 1
fi

# Check if the file exists
if [ ! -f "$FILE3" ]; then
    echo "Error: File '$FILE3' not found!"
    exit 1
fi

# Check if the file exists
if [ ! -f "$FILE4" ]; then
    echo "Error: File '$FILE4' not found!"
    exit 1
fi

# Extract the current version number from FILE
CURRENT_VERSION=$(grep -Eo 'this_version = "[0-9]+\.[0-9]+\.[0-9]+"' "$FILE" | grep -Eo '[0-9]+\.[0-9]+\.[0-9]+')

# Check if the current version was found
if [ -z "$CURRENT_VERSION" ]; then
    echo "Error: Current version not found in '$FILE'."
    exit 1
fi

# Prompt the user for the new version number
read -p "Current version is $CURRENT_VERSION. Enter the new version number: " NEW_VERSION

# Check if the version format is valid (optional)
if [[ ! "$NEW_VERSION" =~ ^[0-9]+\.[0-9]+\.[0-9]+$ ]]; then
    echo "Error: Invalid version format. Use x.y.z format."
    exit 1
fi

# Use sed to update the version number in the file
sed -i.bak -E "s/this_version = \"[0-9]+\.[0-9]+\.[0-9]+\"/this_version = \"$NEW_VERSION\"/" "$FILE"
sed -i.bak -E "s/version = \"[0-9]+\.[0-9]+\.[0-9]+\"/version = \"$NEW_VERSION\"/" "$FILE2"
sed -i.bak -E "s/VERSION=[0-9]+\.[0-9]+\.[0-9]/VERSION=$NEW_VERSION/" "$FILE3"
sed -i.bak -E "s/VERSION=[0-9]+\.[0-9]+\.[0-9]/VERSION=$NEW_VERSION/" "$FILE4"

# Confirm the change
if [ $? -eq 0 ]; then
    echo "Version updated to $NEW_VERSION in $FILE."
    echo "A backup of the original file is saved as $FILE.bak."
    echo "Version updated to $NEW_VERSION in $FILE2."
    echo "A backup of the original file is saved as $FILE2.bak."
    echo "Version updated to $NEW_VERSION in $FILE3."
    echo "A backup of the original file is saved as $FILE3.bak."
    echo "Version updated to $NEW_VERSION in $FILE4."
    echo "A backup of the original file is saved as $FILE4.bak."
    git commit -a -m "new release version number added $NEW_VERSION"
else
    echo "Error: Failed to update the version number."
    exit 1
fi
