"""clev2er.algorithms.base.base_finder"""

import logging
from datetime import datetime

module_log = logging.getLogger(__name__)


class BaseFinder:
    """Base class to find a list of L1b files

    Raises: FileNotFoundError : if base_path is not a valid directory
    """

    def __init__(self, log: logging.Logger | None = None, config: dict | None = None):
        """class initialization function"""
        self.months: list[int] = []
        self.years: list[int] = []
        self.start_date: datetime | None = None
        self.end_date: datetime | None = None
        self.baselines = ""
        if not config:
            self.config: dict = {}
        else:
            self.config = config

        if log is not None:
            self.log = log
        else:
            self.log = module_log

    def add_month(self, months: list[int]) -> None:
        """Add to list of month numbers to load

        Args:
            month (list[int]): month numbers
        """
        for month in months:
            if month < 1 or month > 12:
                raise ValueError("month must be in range 1-12")
            self.months.append(month)

    def add_year(self, years: list[int]) -> None:
        """Add to list of year numbers to load

        Args:
            year (List[int]): list of year numbers in YYYY
        """
        for year in years:
            if year < 1960:
                raise ValueError("year must be > 1960")
            self.years.append(year)

    def find_files(self, flat_search=False) -> list[str]:
        """Search for L1b file according to pattern

        Args:
            flat_search (bool) : if True only search in self.base_path, else use pattern
        Returns:
            (str): list of files

        """
        if flat_search:
            self.log.info("flat search being used")

        file_list: list[str] = []

        return file_list
