"""pytest of algorithm
clev2er.algorithms.iceberg.alg_ib_template.py

Add high level description of algorithm under test here
and integration test purposes

"""

import logging
import os

import pytest
from netCDF4 import Dataset  # pylint:disable=no-name-in-module

from clev2er.utils.testing.testing import initialize_algorithms

# each algorithm test shares some common class code, so pylint: disable=duplicate-code

# NOTE: uncomment next line if the test uses external ADF data larger than 100MB
# pytestmark = pytest.mark.requires_external_data

log = logging.getLogger(__name__)


@pytest.mark.parametrize(
    "dir_path,l1b_file",
    [
        # Simulated L1b covering both hemispheres with points in Grn, non-polar ocean, Ant ocean
        (
            f'{os.environ["CLEV2ER_BASE_DIR"]}/testdata/cristal/l1b/simulated',
            "CRA_IR_1B_HR__SIC_20280103T120129_20280103T120138_20240221T161507_0009"
            "_____________ISRD_SIR_______.NC",
        ),
        # # Add some iceberg transcoded test files examples here
        # (
        #   f'{os.environ["CLEV2ER_BASE_DIR"]}/testdata/cristal/l1b/transcoded/cs2/sin/antarctica',
        #   "CRA_IR_1B_HR__SIC_20220212T115015_20220212T115619_20241001T111801_0364"
        #   "_____________ISRD_SIR_______.NC",
        # ),
    ],
)
def test_alg_ib_template(
    dir_path,
    l1b_file,
) -> None:
    """test of clev2er.algorithms.iceberg.alg_ib_template.py"""

    chain_name = "iceberg"
    alg_name_under_test = "alg_ib_template"

    # ------------------------------------------------------------------------
    # Load chain config files
    # ------------------------------------------------------------------------

    base_dir = os.environ["CLEV2ER_BASE_DIR"]
    assert base_dir is not None

    # Could modify any chain configuration for this test using config_extra.
    # Example:
    # config_extra = {"alg_ib_template": {"some_parameter": True}}
    # config_extra = {}

    init_flag, algorithms, _ = initialize_algorithms(
        chain_name,
        alg_name_under_test,
        log,
        # config_extra={"test": False},  : example
    )

    assert init_flag, "initialization of algorithms failed"

    # ------------------------------------------------------------------------
    # Call the Algorithm's process() function
    # ------------------------------------------------------------------------

    # Test with L1b file

    l1b_file_path = f"{dir_path}/{l1b_file}"

    try:
        # Open the temporary file in read-write mode
        with Dataset(l1b_file_path) as l1b:
            log.info("Opened file %s", l1b_file_path)

            # Run  Algorithm.process()
            shared_dict: dict = {"l1b_file_name": l1b_file}

            # Run  Algorithm.process() for each algorithm
            alg_num = 0  # do not change this from 0, set for the
            #              case where there are no algorithms
            for alg_num, algorithm in enumerate(algorithms):
                alg_name = algorithm.alg_name.split(".")[
                    3
                ]  # "clev2er.algorithms.<chain_name>.<alg_name>"

                return_status, failure_reason = algorithm.process(l1b, shared_dict)

                assert return_status or "SKIP_OK" in failure_reason, failure_reason

                if "SKIP_OK" in failure_reason:
                    log.warning("%s returned SKIP_OK", alg_name)
                    break

                if alg_name == alg_name_under_test:
                    break

            for alg_num_final, algorithm in enumerate(algorithms):
                alg_name = algorithm.alg_name.split(".")[
                    3
                ]  # "clev2er.algorithms.<chain_name>.<alg_name>"
                algorithm.finalize()
                if alg_name == alg_name_under_test or alg_num_final == alg_num:
                    break

    except IOError as exc:
        assert False, f"{l1b_file_path} could not be read: {exc}"

    # ------------------------------------------------------------------------
    # Test the algorithm's outputs are as expected
    # ------------------------------------------------------------------------

    # assert shared_dict["????"]["????"] == ????, msg
    # include any necessary logic here
