"""pytest functions to test
src/clev2er/tools/run_chain.py: runc_chain()
"""

import logging
import os

import pytest

from clev2er.tools.run_chain import run_chain
from clev2er.utils.config.load_config_settings import (
    load_algorithm_list,
    load_config_files,
)

# pylint: disable=too-many-locals

log = logging.getLogger(__name__)


@pytest.mark.parametrize("mp_enabled", [(False), (True)])
def test_run_chain(mp_enabled):
    """pytest functions to test src/clev2er/tools/run_chain.py: run_chain()"""
    chain_name = "testchain"
    base_dir = os.environ["CLEV2ER_BASE_DIR"]
    assert base_dir is not None

    # Load merged config file for chain
    config, _, _ = load_config_files(chain_name)

    config["chain"]["chain_name"] = chain_name
    config["chain"]["use_multi_processing"] = mp_enabled

    # Need to set MP mode, so Linux doesn't default to fork()
    # if mp_enabled:
    #     if mp.get_start_method(allow_none=True) != "spawn":
    #         mp.set_start_method("spawn")

    algorithm_list, _, algorithm_list_file, _ = load_algorithm_list(chain_name)

    assert os.path.exists(algorithm_list_file)

    l1b_file_list = [
        (
            f"{os.environ['CLEV2ER_BASE_DIR']}/testdata/cristal/l1b/simulated/"
            "CRA_IR_1B_HR__SIC_20280103T120129_20280103T120138_"
            "20240221T161507_0009_____________ISRD_SIR_______.NC"
        ),
        (
            f"{os.environ['CLEV2ER_BASE_DIR']}/testdata/cristal/l1b/simulated/"
            "CRA_IR_1B_LR__SIC_20280103T120129_20280103T120138_"
            "20240221T161507_0009_____________ISRD_SIR_______.NC"
        ),
    ]

    success, num_errors, num_files_processed, num_skipped, _, shared_dict = run_chain(
        l1b_file_list=l1b_file_list,
        config=config,
        algorithm_list=algorithm_list,
        log=log,
    )

    assert num_errors == 0
    assert num_files_processed == len(l1b_file_list)
    assert num_skipped == 0
    assert success, "run_chain return failure status"
    if mp_enabled is False:
        assert "l1b_file_name" in shared_dict
        assert (
            "20240221T161507_0009" in shared_dict["l1b_file_name"]
        ), "should contain final L1b file name"
        assert "dummy_parameter1" in shared_dict
        assert "dummy_parameter2" in shared_dict
    else:
        assert (
            bool(shared_dict) is False
        )  # for multi-processing shared_dict is expected to be empty
