"""pytest of utils.config.load_config_files()"""

import os

from clev2er.utils.config.load_config_settings import load_algorithm_list


def test_load_algorithm_list():
    """pytest function for utils.config.load_algorithm_list()"""

    # ----------------------------------------------------------------
    # test with chain: testchain which should return
    #  2 algorithms and no finders
    # -----------------------------------------------------------------
    chain_name = "testchain"

    try:
        (
            alg_list,
            finder_list,
            _,  # filename of algorithm list
            _,  # breakpoint name
        ) = load_algorithm_list(chain_name)
    except (KeyError, OSError, ValueError) as exc:
        assert False, f"Loading config file failed due to {exc}"

    n_algs = len(alg_list)
    assert n_algs == 2, f"Should return two algorithms from testchain but {n_algs} returned"

    n_finders = len(finder_list)
    assert n_finders == 0, "Should be no finders returned from testchain"

    # ----------------------------------------------------------------
    # test with chain: testchain baseline-b which should return
    #  2 algorithms and 0 finders
    # -----------------------------------------------------------------

    chain_name = "testchain"

    try:
        (
            alg_list,
            finder_list,
            _,  # filename of algorithm list
            _,  # breakpoint name
        ) = load_algorithm_list(chain_name)
    except (KeyError, OSError, ValueError) as exc:
        assert False, f"Loading config file failed due to {exc}"

    n_algs = len(alg_list)
    assert n_algs == 2, f"Should return 2 algorithms from testchain but {n_algs} returned"

    n_finders = len(finder_list)
    assert n_finders == 0, "Should be 0 finders returned from testchain"

    try:
        (
            alg_list,
            finder_list,
            _,  # filename of algorithm list
            _,  # breakpoint name
        ) = load_algorithm_list(
            chain_name,
            alg_list_file=f"{os.environ['CLEV2ER_BASE_DIR']}"
            "/config/algorithm_lists/testchain/testchain_alglist.xml",
        )
    except (KeyError, OSError, ValueError) as exc:
        assert False, f"Loading config file failed due to {exc}"

    n_algs = len(alg_list)
    assert n_algs == 2, f"Should return 2 algorithms from testchain but {n_algs} returned"
