"""Test of clev2er.utils.testing.testing.initialize_algorithms"""

import logging
import os

from clev2er.utils.testing.testing import initialize_algorithms

# Get a logger instance from pytest
log = logging.getLogger(__name__)


def test_initialize_algorithms() -> None:
    """pytest of clev2er.utils.testing.testing.initialize_algorithms"""

    base_dir = os.environ["CLEV2ER_BASE_DIR"]
    assert base_dir is not None

    alg_name_under_test = "alg_template2"
    chain_name = "testchain"

    init_flag, algorithms, config = initialize_algorithms(chain_name, alg_name_under_test, log)

    assert init_flag, "initialization of algorithms failed"
    assert config["chain"]["chain_name"] == chain_name

    # Run the algorithm finalize() functions to clean up
    for algorithm in algorithms:
        # Clean up algorithm
        algorithm.finalize()
