#!/bin/bash

# Build the CLEV2ER SII src tar.gz, separating SI, IB and Both
# run from within software/clev2er_sii on Mac

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

version=$(grep -Eo 'this_version = "[0-9]+\.[0-9]+\.[0-9]+"' "./src/clev2er/tools/run_chain.py" | grep -Eo '[0-9]+\.[0-9]+\.[0-9]+')

echo -e "${GREEN}version=$version${NC}"

cd ~/Downloads

if [ ! -f clev2er_sii-${version}.tar.gz ]; then
    echo -e "${RED}~/Downloads/clev2er_sii-${version}.tar.gz does not exist, download from GitHub release first${NC}"
    exit 1
fi

echo -e "${GREEN}found clev2er_sii-${version}.tar.gz${NC}"

tar --no-xattrs -xzf clev2er_sii-${version}.tar.gz 

echo "Creating release for BOTH..."

tar --no-xattrs --exclude="docs/clev2er" \
-czf clev2er_sii_siib-${version}.tar.gz clev2er_sii-${version}

echo "Creating IB release..."

tar --no-xattrs --exclude="src/clev2er/algorithms/seaice" \
--exclude="config/algorithm_lists/seaice" \
--exclude="config/chain_configs/seaice" \
--exclude="testdata/adf/seaice" \
--exclude="docs/clev2er" \
-czf clev2er_sii_ib-${version}.tar.gz clev2er_sii-${version}

echo "Creating SI release..."
tar --no-xattrs --exclude="src/clev2er/algorithms/iceberg" \
--exclude="config/algorithm_lists/iceberg" \
--exclude="config/chain_configs/iceberg" \
--exclude="testdata/adf/iceberg" \
--exclude="docs/clev2er" \
-czf clev2er_sii_si-${version}.tar.gz clev2er_sii-${version}

echo "Creating SHA256 files."

shasum -a 256 clev2er_sii_siib-${version}.tar.gz > clev2er_sii_siib-${version}.tar.gz.sha256
shasum -a 256 clev2er_sii_si-${version}.tar.gz > clev2er_sii_si-${version}.tar.gz.sha256
shasum -a 256 clev2er_sii_ib-${version}.tar.gz > clev2er_sii_ib-${version}.tar.gz.sha256

rm -rf clev2er_sii-${version}

echo "clev2er_sii_siib-${version}.tar.gz created"
echo "clev2er_sii_si-${version}.tar.gz created"
echo "clev2er_sii_ib-${version}.tar.gz created"

echo "clev2er_sii_siib-${version}.tar.gz.sha256 created"
echo "clev2er_sii_si-${version}.tar.gz.sha256 created"
echo "clev2er_sii_ib-${version}.tar.gz.sha256 created"

ls -lh clev2er_sii*${version}.tar.*

rm -f clev2er_sii-${version}.tar.gz

echo "Uploading to li1.cpom.ucl.ac.uk:/cpnet/www/cpom/downloads/clev2er_sii..."
rsync -av ~/Downloads/clev2er_sii_*${version}.tar.* asm@li1.cpom.ucl.ac.uk:/cpnet/www/cpom/downloads/clev2er_sii

