#!/bin/bash

# Build ADF/TDS archive files for CLEV2ER SII installations
# To be run from the GPP repository base dir

# Find the current version of the GPP software
CURRENT_VERSION=$(grep -Eo 'this_version = "[0-9]+\.[0-9]+\.[0-9]+"' "./src/clev2er/tools/run_chain.py" | grep -Eo '[0-9]+\.[0-9]+\.[0-9]+')

echo "Creating TDS for both : siib.."
tar -czf testdata_external_siib_$CURRENT_VERSION.tar.gz testdata_external
sha256sum testdata_external_siib_$CURRENT_VERSION.tar.gz > testdata_external_siib_$CURRENT_VERSION.tar.gz.sha256
ls -lh testdata_external_siib_$CURRENT_VERSION.tar.gz

# Prepare test data/ADF for just LI
echo "Creating TDS for SI .."
tar --exclude="adf/seaice"  -czf testdata_external_si_$CURRENT_VERSION.tar.gz testdata_external
sha256sum testdata_external_si_$CURRENT_VERSION.tar.gz > testdata_external_si_$CURRENT_VERSION.tar.gz.sha256

# Prepare test data/ADF for just IW
echo "Creating TDS for IB .."
tar --exclude="adf/iceberg"  -czf testdata_external_ib_$CURRENT_VERSION.tar.gz testdata_external
sha256sum testdata_external_ib_$CURRENT_VERSION.tar.gz > testdata_external_ib_$CURRENT_VERSION.tar.gz.sha256

echo "Uploading to  li1.cpom.ucl.ac.uk:/cpnet/www/cpom/downloads/clev2er_sii ..."

rsync -av testdata_external_*_$CURRENT_VERSION.tar.* asm@li1.cpom.ucl.ac.uk:/cpnet/www/cpom/downloads/clev2er_sii

ls -lh testdata_external*$CURRENT_VERSION.tar.gz

rm testdata_external*$CURRENT_VERSION.tar.*

