#!/bin/bash

# Check if the argument is provided
if [ -z "$1" ]; then
    echo "Usage: $0 <test number (not zero padded)>"
    exit 1
fi

ONUM=$1
NUM=$(printf "%03d" $ONUM)

# Create the directory
DIR="verification_tests/tc-ver-$NUM"
mkdir -p "$DIR"

if [ -f $DIR/test.sh ]; then
    echo "test already exists for TC-VER-$NUM"
    read -p "Overwrite (Y/N): " ANSWER
    if [ $ANSWER != "Y" ] ; then
        echo "exiting - No test created"
        exit 1
    fi
fi

# Create the test.sh file with the template
cat <<EOL > "$DIR/test.sh"
#!/bin/bash

#--------------------------------------------------------------------------------------------------------
# Verification test ID: TC-VER-$NUM
#--------------------------------------------------------------------------------------------------------

TEST_ID="TC-VER-$NUM"

# Start time
start_time=\$(date +%s)

#--------------------------------------------------------------------------------------------------------
# Case tested:
#--------------------------------------------------------------------------------------------------------

#--------------------------------------------------------------------------------------------------------
# Method used:
#--------------------------------------------------------------------------------------------------------

#--------------------------------------------------------------------------------------------------------
# Pass Criteria
#--------------------------------------------------------------------------------------------------------

#--------------------------------------------------------------------------------------------------------
# Inputs:
#--------------------------------------------------------------------------------------------------------


#--------------------------------------------------------------------------------------------------------
# Expected Outputs
#--------------------------------------------------------------------------------------------------------
#

#--------------------------------------------------------------------------------------------------------
# Test Processing
#--------------------------------------------------------------------------------------------------------

# Setup some colors for test clarity
GREEN='\033[0;32m'
RED='\033[0;31m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
BLACK_BOLD = '\033[1;30m'
NC='\033[0m' # No Color

# Function to ensure valid input
# usage: ensure_valid_response "Y N" "Enter Y or N" ANSWER
ensure_valid_response() {
    local options="\$1"
    local prompt_message="\$2"
    local response_var="\$3"
    while true; do
        read -p "\$prompt_message" RESPONSE
        RESPONSE=\${RESPONSE:-\$DEFAULT_RESPONSE}
        for option in \${options//,/ }; do
            if [[ "\$RESPONSE" == "\$option" ]]; then
                eval \$response_var="'\$RESPONSE'"
                return 0
            fi
        done
        echo "Invalid response. Please enter one of: \$options."
    done
}

clear
echo -e "\${BLUE}TEST ID: \$TEST_ID\${NC}\n"

echo "GPP version used: "
run_chain -v

echo ""

# --------------------------------------------
# perform test here and return correct status
# --------------------------------------------
echo "------------------------------------------------------"
echo -e "Test processing started at $(date)"
echo "------------------------------------------------------"
echo 

test_return_status=2  # 0 (pass), 1 (fail), 2 (not implemented)

echo "------------------------------------------------------"
echo "Test processing ended at $(date)"
echo "------------------------------------------------------"

# End time
end_time=\$(date +%s)

# Calculate execution time
execution_time=\$((end_time - start_time))

# Print execution time
echo "Execution time: \$execution_time seconds"

if [ \$test_return_status -eq 0 ]; then
    echo -e "\${GREEN}Test \$TEST_ID passed!\${NC}"
elif [ \$test_return_status -eq 1 ]; then
    echo -e "\${RED}Test \$TEST_ID failed!\${NC}"
elif [ \$test_return_status -eq 2 ]; then
    echo -e "\${YELLOW}Test \$TEST_ID not implemented!\${NC}"
fi

exit \$test_return_status
EOL

# Make the script executable
chmod +x "$DIR/test.sh"

echo "New Test template created for TC-VER-$NUM"

grep "tc-ver-${NUM}" test_results.txt > /dev/null
if [ $? -eq 1 ] ; then
    echo "Updating test database.."
    YELLOW='\033[1;33m'
    NC='\033[0m' # No Color
    echo -e "tc-ver-${NUM}: ${YELLOW}NOT IMPLEMENTED${NC}" >> test_results.txt
fi


git add $DIR


