#!/bin/bash

#--------------------------------------------------------------------------------------------------------
# Verification test ID: TC-VER-004
#--------------------------------------------------------------------------------------------------------

TEST_ID="TC-VER-004"

# Start time
start_time=$(date +%s)

#--------------------------------------------------------------------------------------------------------
# Case tested:
#--------------------------------------------------------------------------------------------------------

#--------------------------------------------------------------------------------------------------------
# Method used:
#--------------------------------------------------------------------------------------------------------

#--------------------------------------------------------------------------------------------------------
# Pass Criteria
#--------------------------------------------------------------------------------------------------------

#--------------------------------------------------------------------------------------------------------
# Inputs:
#--------------------------------------------------------------------------------------------------------


#--------------------------------------------------------------------------------------------------------
# Expected Outputs
#--------------------------------------------------------------------------------------------------------
#

#--------------------------------------------------------------------------------------------------------
# Test Processing
#--------------------------------------------------------------------------------------------------------

# Setup some colors for test clarity
GREEN='\033[0;32m'
RED='\033[0;31m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
BLACK_BOLD = '\033[1;30m'
NC='\033[0m' # No Color

# Function to ensure valid input
# usage: ensure_valid_response "Y N" "Enter Y or N" ANSWER
ensure_valid_response() {
    local options="$1"
    local prompt_message="$2"
    local response_var="$3"
    while true; do
        read -p "$prompt_message" RESPONSE
        RESPONSE=${RESPONSE:-$DEFAULT_RESPONSE}
        for option in ${options//,/ }; do
            if [[ "$RESPONSE" == "$option" ]]; then
                eval $response_var="'$RESPONSE'"
                return 0
            fi
        done
        echo "Invalid response. Please enter one of: $options."
    done
}

clear
echo -e "${BLUE}TEST ID: $TEST_ID${NC}\n"

echo "GPP version used: "
run_chain -v

echo ""

# --------------------------------------------
# perform test here and return correct status
# --------------------------------------------
echo "------------------------------------------------------"
echo -e "Test processing started at Sat Jul  6 18:00:59 BST 2024"
echo "------------------------------------------------------"
echo 

test_return_status=2  # 0 (pass), 1 (fail), 2 (not implemented)

echo "------------------------------------------------------"
echo "Test processing ended at Sat Jul  6 18:00:59 BST 2024"
echo "------------------------------------------------------"

# End time
end_time=$(date +%s)

# Calculate execution time
execution_time=$((end_time - start_time))

# Print execution time
echo "Execution time: $execution_time seconds"

if [ $test_return_status -eq 0 ]; then
    echo -e "${GREEN}Test $TEST_ID passed!${NC}"
elif [ $test_return_status -eq 1 ]; then
    echo -e "${RED}Test $TEST_ID failed!${NC}"
elif [ $test_return_status -eq 2 ]; then
    echo -e "${YELLOW}Test $TEST_ID not implemented!${NC}"
fi

exit $test_return_status
